/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.device.DeviceContext;
import com.tp_link.eap.device.EventType;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.LogInfo;
import com.tp_link.eap.domain.eap.RogueAp;
import com.tp_link.eap.domain.eap.StatCurrentAp;
import com.tp_link.eap.domain.eap.StatCurrentSsid;
import com.tp_link.eap.domain.eap.StatRADaily;
import com.tp_link.eap.domain.eap.StatRAHourly;
import com.tp_link.eap.domain.eap.bean.AdoptInfo;
import com.tp_link.eap.domain.eap.bean.ApMonitorInfo;
import com.tp_link.eap.domain.eap.bean.IpSetting;
import com.tp_link.eap.domain.eap.bean.LanPortSetting;
import com.tp_link.eap.domain.eap.bean.LoadBalance;
import com.tp_link.eap.domain.eap.bean.Location;
import com.tp_link.eap.domain.eap.bean.Radio;
import com.tp_link.eap.domain.eap.bean.RadioMode;
import com.tp_link.eap.domain.eap.bean.RssiThreshold;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.eap.bean.TrunkSetting;
import com.tp_link.eap.domain.eap.bean.WirelessParam;
import com.tp_link.eap.domain.eapsetting.LoadBalanceConfig;
import com.tp_link.eap.domain.eapsetting.ManagementVlanConfig;
import com.tp_link.eap.domain.eapsetting.RadioRssi;
import com.tp_link.eap.domain.eapsetting.RogueApGlobal;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocAp;
import com.tp_link.eap.domain.eapsetting.SsidC;
import com.tp_link.eap.domain.eapsetting.SsidConfig;
import com.tp_link.eap.domain.eapsetting.SsidRateLimit;
import com.tp_link.eap.domain.eapsetting.WirelessBasicConfig;
import com.tp_link.eap.domain.eapstats.DevCap;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.eapstats.MeshInfo;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.QosSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.UserAccountSetting;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.globalsetting.bean.RegionWireParam;
import com.tp_link.eap.domain.mesh.bean.CandidateParentApInfo;
import com.tp_link.eap.domain.mesh.bean.MeshConf;
import com.tp_link.eap.domain.mesh.bean.MeshDfsRecord;
import com.tp_link.eap.domain.mesh.bean.MeshFailoverRecord;
import com.tp_link.eap.domain.mesh.bean.MeshRelation;
import com.tp_link.eap.domain.mesh.bean.MeshState;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.mesh.document.StatMeshInfo;
import com.tp_link.eap.domain.mesh.pojo.IsolatedAP;
import com.tp_link.eap.domain.mesh.pojo.Mesh;
import com.tp_link.eap.domain.message.Authentication;
import com.tp_link.eap.domain.message.UpgradeMsg;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.system.OperationRecord;
import com.tp_link.eap.domain.system.Stat;
import com.tp_link.eap.domain.system.UpgradeWarning;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.cloud.model.ModelFwEntry;
import com.tp_link.eap.monitor.globalsetting.model.ApBriefInfo;
import com.tp_link.eap.monitor.globalsetting.model.ApGridBriefInfo;
import com.tp_link.eap.monitor.globalsetting.model.ApInfo;
import com.tp_link.eap.monitor.globalsetting.model.SchedulerAssociationApInfo;
import com.tp_link.eap.monitor.globalsetting.service.impl.SsidSettingService;
import com.tp_link.eap.monitor.monitor.cache.CacheTask;
import com.tp_link.eap.monitor.monitor.cache.ClientConnection;
import com.tp_link.eap.monitor.monitor.model.DeviceMiscModel;
import com.tp_link.eap.monitor.monitor.model.LoadBalanceModel;
import com.tp_link.eap.monitor.monitor.model.LoadBalanceWithRssi;
import com.tp_link.eap.monitor.monitor.model.RadioModel;
import com.tp_link.eap.monitor.monitor.model.RegionParamModel;
import com.tp_link.eap.monitor.monitor.realtime.RealtimeStatus;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.repo.StatCurApRepository;
import com.tp_link.eap.monitor.monitor.repo.StatRADailyRepository;
import com.tp_link.eap.monitor.monitor.repo.StatRAHourlyRepository;
import com.tp_link.eap.monitor.monitor.service.impl.a;
import com.tp_link.eap.monitor.monitor.service.impl.b;
import com.tp_link.eap.monitor.monitor.service.impl.c;
import com.tp_link.eap.monitor.monitor.service.impl.d;
import com.tp_link.eap.monitor.monitor.service.impl.e;
import com.tp_link.eap.monitor.monitor.service.impl.f;
import com.tp_link.eap.monitor.monitor.service.impl.g;
import com.tp_link.eap.monitor.monitor.service.impl.h;
import com.tp_link.eap.monitor.monitor.service.impl.i;
import com.tp_link.eap.monitor.monitor.service.impl.j;
import com.tp_link.eap.monitor.monitor.service.impl.k;
import com.tp_link.eap.monitor.monitor.service.impl.l;
import com.tp_link.eap.monitor.monitor.service.impl.m;
import com.tp_link.eap.monitor.monitor.service.impl.n;
import com.tp_link.eap.monitor.monitor.service.impl.o;
import com.tp_link.eap.monitor.monitor.service.impl.p;
import com.tp_link.eap.monitor.monitor.service.impl.q;
import com.tp_link.eap.monitor.monitor.service.impl.r;
import com.tp_link.eap.monitor.monitor.upgrade.SingleUpgradeResult;
import com.tp_link.eap.monitor.monitor.upgrade.SingleUpgradeResult$UpgradeResult;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.model.ModelCache;
import com.tp_link.eap.util.model.ModelModelVersionGenerator;
import com.tp_link.eap.util.model.ModelVersionAdjustment;
import com.tplink.eap.cloudsdk.DeviceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="apService")
public class ApService
extends com.tp_link.eap.i.a.a<Ap>
implements com.tp_link.eap.monitor.monitor.service.b {
    private static final long c = 30000L;
    private static final long d = 120000L;
    private static final long e = 20000L;
    private static final long f = 4000L;
    private static final long g = 40000L;
    private static final String h = "192.168.0.254";
    @Autowired
    private ApRepository i;
    @Autowired
    private StatCurApRepository j;
    @Autowired
    private StatRAHourlyRepository k;
    @Autowired
    private StatRADailyRepository l;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.f m;
    @Autowired
    private com.tp_link.eap.monitor.cloud.device.service.a n;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a o;
    @Autowired
    private MongoTemplate p;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.j q;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.d r;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.b s;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.g t;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.i u;
    @Autowired
    private SsidSettingService v;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a w;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.e x;
    @Autowired
    private com.tp_link.eap.monitor.record.service.b y;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.g z;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d A;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.n B;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.a C;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.a D;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.c E;
    @Autowired
    private com.tp_link.eap.monitor.compatibility.service.b F;
    @Autowired
    private com.tp_link.eap.monitor.roaming.service.a G;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.e H;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.b I;
    @Autowired
    private Validator validator;
    @Autowired
    private com.tp_link.eap.monitor.system.service.a J;
    private static final int K = 10;
    private static final int L = 1000;
    private static final int M = 12;
    private static final int N = 2000;
    private static final int O = 500;
    private static final String P = "modelModelVersion";
    private static final String Q = "status";
    private static final String R = "percent";
    private static final String S = "curFwVer";
    private static final String T = "canOnlineUpgrade";
    private static final String U = "lastFwVer";
    private static final String V = "fwReleaseLog";
    private static final long W = 86400L;
    private static final double X = 0.3;
    private static final double Y = 0.7;
    public static final String a = "data" + File.separatorChar + "eap-firmware";
    private Object Z = new Object();
    private ConcurrentHashMap<String, q> aa = new ConcurrentHashMap();
    private ConcurrentHashMap<String, o> ab = new ConcurrentHashMap();
    private Set<String> ac = new HashSet<String>();
    private ExecutorService ad = Executors.newCachedThreadPool();
    private static final Logger ae = LoggerFactory.getLogger(ApService.class);
    private ExecutorService af = Executors.newFixedThreadPool(com.tp_link.eap.c.a.c);

    @Override
    public Ap getApDetail(String apMac) {
        if (apMac == null) {
            return null;
        }
        Ap ap = this.i.findByMac(apMac);
        if (ap == null) {
            return null;
        }
        StatCurrentAp statCurrentAp = this.j.findByApMac(ap.getMac());
        ap.setSca(statCurrentAp);
        return ap;
    }

    @Override
    public Ap getAp(String apid) {
        if (apid == null) {
            return null;
        }
        return (Ap)this.i.findOne((Serializable)((Object)apid));
    }

    @Override
    public Ap getApByMac(String apMac) {
        if (com.tp_link.eap.util.a.e.a((String)apMac)) {
            return null;
        }
        return this.i.findByMac(apMac);
    }

    @Override
    public OperationResponse getApDetail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac");
        if (string == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getApDetail(string);
        if (ap != null && ap.getWirelessLinked().booleanValue() && ap.getStatus() != 2 && com.tp_link.eap.util.l.e((DeviceMisc)ap.getDeviceMisc())) {
            boolean bl = this.getMeshChannelLimit(string);
            if (ap.getRadio5g() != null) {
                ap.getRadio5g().setMeshChannelLimit(bl);
                ap.getRadio().setMeshChannelLimit(bl);
            }
        }
        return new OperationResponse(ResErrorCode.a, (Object)ap);
    }

    @Override
    public List<Ap> getAps() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.i.findAll());
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Ap ap = (Ap)list.get(i2);
            ap.setSca(this.j.findByApMac(ap.getMac()));
            list.set(i2, ap);
        }
        return list;
    }

    public List<Ap> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null, null);
    }

    public List<Ap> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<Ap> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<Ap> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Ap> list = this.i.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Ap ap = list.get(i2);
            ap.setSca(this.j.findByApMac(ap.getMac()));
            list.set(i2, ap);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePendingAp(String apMac) {
        ae.debug("deletePendingAp");
        Ap ap = this.i.findByMac(apMac);
        if (ap != null && ap.getStatus() == 2) {
            Object object;
            if (!(!ap.getWirelessLinked().booleanValue() || ap.getMeshConf() == null || com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac()) && CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs()))) {
                return;
            }
            Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
            synchronized (object2) {
                this.i.delete(ap);
            }
            if (com.tp_link.eap.monitor.monitor.realtime.a.g(apMac)) {
                com.tp_link.eap.monitor.monitor.realtime.a.f(apMac);
            }
        }
    }

    @Override
    public OperationResponse adoptAp(String apMac, String username, String password, String parentMac) {
        AdoptInfo adoptInfo;
        if (!com.tp_link.eap.util.l.b() && this.i.countByAdopted(true) >= 100L) {
            ae.warn("Adopted AP num {} has reached max AP num on cloud key, auto adopt failed");
            return new OperationResponse(ResErrorCode.dk);
        }
        ae.debug("adoptAp " + apMac + username + password + parentMac);
        if (apMac == null || username == null || password == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.i.findByMac(apMac);
        if (ap == null) {
            ae.info("AP to be adopted doesn't exist for ap mac :" + apMac);
            return new OperationResponse(ResErrorCode.J);
        }
        if (ap.getStatus() != 2) {
            return new OperationResponse(ResErrorCode.dT);
        }
        if (ap.getWirelessLinked().booleanValue() && com.tp_link.eap.util.restore.c.g() != null && !com.tp_link.eap.util.restore.c.g().isFinished()) {
            ae.warn("Restore is progressing");
            return new OperationResponse(ResErrorCode.dy);
        }
        if (com.tp_link.eap.monitor.monitor.realtime.a.g(ap.getMac())) {
            ae.warn("AP to be adopted is adopting.");
            return new OperationResponse(ResErrorCode.K);
        }
        com.tp_link.eap.d.b.b((String)ap.getMac(), (String)com.tp_link.eap.d.b.a());
        com.tp_link.eap.monitor.monitor.realtime.a.e(ap.getMac());
        if (ap.getWirelessLinked().booleanValue() && ap.getStatusWireless() != null && ap.getStatusWireless() == 1 && !(adoptInfo = this.a(ap.getMac(), username, password, parentMac)).success()) {
            com.tp_link.eap.monitor.monitor.realtime.a.f(ap.getMac());
            Ap ap2 = this.getApByMac(ap.getMac());
            if (ap2 != null && ap2.getAdoptStatus() == 1) {
                this.setApAdoptStatus(ap2.getMac(), 2);
            }
            return adoptInfo;
        }
        ae.debug("Adopt step: start");
        ap = this.i.findByMac(ap.getMac());
        adoptInfo = new AdoptInfo(username, password);
        com.tp_link.eap.monitor.monitor.realtime.a.a(apMac, adoptInfo);
        ae.debug("add mac to adopt store for mac: " + ap.getMac());
        Authentication authentication = new Authentication();
        authentication.setIp(ap.getIp());
        ae.debug("Adopt step2, connect ip:" + ap.getIp());
        authentication.setMac(apMac);
        authentication.setUserName(username);
        authentication.setPassword(password);
        com.tp_link.eap.util.b.c((String)apMac);
        Ap ap3 = ap;
        this.ad.execute(new a(this, apMac, ap3, authentication));
        int n2 = this.a(apMac, (boolean)ap.getWirelessLinked());
        ae.debug("adopt result of mac " + apMac + " is :" + com.tp_link.eap.util.b.e((String)apMac) + " , and remove mac from adopt store");
        com.tp_link.eap.monitor.monitor.realtime.a.f(apMac);
        MeshState.refreshComplete((String)ap.getMac());
        if (!com.tp_link.eap.util.b.e((String)apMac)) {
            this.setApAdoptStatus(apMac, 2);
            this.setStatusWireless(apMac, 1);
            ae.debug("deleteRelationship");
            this.disconnectChildAp(ap.getMac(), false);
            this.E.refreshStatus(ap.getMac(), 3);
            if (n2 >= 10) {
                ae.debug("Adopt step: connect time out");
                return new OperationResponse(ResErrorCode.L);
            }
            ae.debug("Adopt step: invalid credential");
            return new OperationResponse(ResErrorCode.M);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public void disconnectChildAp(String mac, boolean clearTryParentHistory) {
        Ap ap = this.i.findByMac(mac);
        if (ap == null) {
            ae.debug("Failed to disconnect ap, child ap not found");
            return;
        }
        if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            String string = ap.getMeshConf().getParentApMac();
            String string2 = ap.getMac();
            ae.debug("deleteRelationship");
            this.E.deleteRelationship(string, string2, clearTryParentHistory);
            this.E.sendDisconnectCommand(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(String string, String string2, String string3, String string4) {
        String string5;
        Object object;
        Object object2;
        ae.debug("buildWirelessConnection {}", (Object)string);
        MeshState.refreshConnecting((String)string);
        String string6 = com.tp_link.eap.d.b.e((String)string);
        Object object3 = object2 = com.tp_link.eap.b.b.a.j((String)string6);
        synchronized (object3) {
            Ap ap = this.getApDetail(string);
            boolean bl = false;
            if (com.tp_link.eap.util.a.e.a((String)string4)) {
                string4 = this.D.autoElectParentAp(ap, string6);
                ae.debug("autoElectParentAp {} for child {}", (Object)string4, (Object)ap.getMac());
            } else {
                bl = true;
            }
            if (com.tp_link.eap.util.a.e.a((String)string4)) {
                MeshState.refreshComplete((String)string);
                return new OperationResponse(ResErrorCode.dR);
            }
            object = this.i.findByMac(string4);
            if (object == null) {
                MeshState.refreshComplete((String)string);
                return new OperationResponse(ResErrorCode.dR);
            }
            if (!bl) {
                if (this.E.calcChildApCnt((Ap)object) >= 4) {
                    string5 = this.E.giveDisChild((Ap)object);
                    if (!com.tp_link.eap.util.a.e.a((String)string5)) {
                        ae.debug("disConnectParentAp");
                        this.E.disConnectParentAp(string5, string4, false, true, false);
                    } else {
                        ae.debug("The downlink AP number of the uplink AP has reached the limit.");
                        MeshState.refreshComplete((String)string);
                        return new OperationResponse(ResErrorCode.dI);
                    }
                }
                if (!this.E.isValidParent(ap, (Ap)object).success()) {
                    MeshState.refreshComplete((String)string);
                    return new OperationResponse(ResErrorCode.dS);
                }
            }
            this.E.saveMeshConf(string, string4);
        }
        ae.debug("real buildWirelessConnection start {} ", (Object)string);
        this.setApAdoptStatus(string, 1);
        this.E.refreshStatus(string, 1);
        this.E.sendAddCommand(string4, string, string2, string3);
        int n2 = com.tp_link.eap.util.l.b((Ap)this.i.findByMac(string4));
        ae.debug("dfs time: " + n2);
        if (n2 >= 0) {
            MeshDfsRecord.refresh((String)string, (long)(System.currentTimeMillis() + (long)(n2 * 1000)));
            ae.debug("Build mesh connection step: wait for dfs");
            try {
                Thread.sleep(n2 * 1000);
            }
            catch (InterruptedException interruptedException) {
                ae.warn("DFS waiting interrupted");
            }
            MeshDfsRecord.remove((String)string);
            ae.debug("Build mesh connection step: wait for dfs end");
        }
        ae.debug("Build mesh connection step: after send instruction for " + string);
        int n3 = 0;
        Ap ap = this.i.findByMac(string);
        while (ap == null || 2 != ap.getStatusWireless()) {
            if (30000L * (long)(++n3) > 120000L) {
                ae.debug("deleteRelationship {}", (Object)string);
                this.disconnectChildAp(string, false);
                this.E.refreshStatus(string, 3);
                object = com.tp_link.eap.b.b.a.a((String)string);
                string5 = object;
                synchronized (string5) {
                    Ap ap2 = this.getApByMac(string);
                    if (ap2 != null && ap2.getWirelessLinked().booleanValue()) {
                        ap2.setAdoptStatus(2);
                        ap2.setStatusWireless(Integer.valueOf(1));
                        ap2.setIp(null);
                        ap2.setVersion(null);
                        this.refreshAp(ap2);
                    }
                }
                com.tp_link.eap.monitor.monitor.realtime.a.f(string);
                MeshState.refreshComplete((String)string);
                return new OperationResponse(ResErrorCode.dL);
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                ae.warn("Exception when polling for pending status of isolated AP", (Throwable)interruptedException);
            }
            ap = this.i.findByMac(string);
        }
        ae.debug("Build mesh connection step: polling finish {}", (Object)string);
        ae.debug("Build mesh connection step: wait for dhcp");
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            ae.warn("DHCP waiting interrupted");
        }
        int n4 = 0;
        while (!this.a(ap.getMac()) && 4000L * (long)n4 <= 40000L) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                ae.warn("DHCP waiting interrupted");
            }
            ++n4;
        }
        ae.debug("Build mesh connection step: wait for dhcp end {}", (Object)string);
        return com.tp_link.eap.util.e.bd;
    }

    private boolean a(String string) {
        Ap ap = this.i.findByMac(string);
        return !com.tp_link.eap.util.a.e.a((String)ap.getIp()) && !ap.getIp().equals(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse forgetAp(String apId) {
        Object object;
        if (com.tp_link.eap.util.a.e.a((String)apId)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            ae.debug("AP to be deleted doesn't existed.");
            return new OperationResponse(ResErrorCode.au);
        }
        if (com.tp_link.eap.monitor.monitor.realtime.c.d(ap.getMac())) {
            return new OperationResponse(ResErrorCode.av);
        }
        ae.debug("forget {}", (Object)ap.getMac());
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
        synchronized (object2) {
            CacheTask.a.a(ap.getMac());
            com.tp_link.eap.monitor.monitor.realtime.a.f(ap.getMac());
            MeshState.refreshComplete((String)ap.getMac());
            com.tp_link.eap.monitor.monitor.realtime.a.d(ap.getMac());
            this.i.delete(ap);
            this.w.deleteRecord(ap.getMac(), true);
            com.tp_link.eap.monitor.record.a.a.d(ap.getMac());
            this.y.deleteSettingVersion(ap.getMac());
        }
        this.clearStatistics(ap.getMac());
        this.t.deleteLogs(ap.getMac());
        this.s.delAllGuestByAp(ap.getMac());
        com.tp_link.eap.d.b.d((String)ap.getMac());
        object2 = ap.getMac();
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_FORGET, null, null, (String)object2);
        if (ap.getMeshConf() != null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                ae.warn(interruptedException.toString(), (Throwable)interruptedException);
            }
            if (!com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
                String string = ap.getMeshConf().getParentApMac();
                this.E.sendDisconnectCommand(string, ap.getMac());
                this.E.deleteStatMeshInfo(ap.getMac());
            }
            this.E.deleteMeshConf(ap);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheAp(String apMac, ApMonitorInfo ami, int controllerIdResult) {
        Object object;
        if (apMac == null || ami == null) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap != null && ap.getStatus() != 2) {
                ae.debug("not pending status");
                return false;
            }
            if (ami.getWirelessLinked().booleanValue() && ap == null) {
                ae.debug("illegal wireless ap");
                return false;
            }
            if (ap == null) {
                CacheTask.a.a(apMac);
                Ap ap2 = new Ap();
                this.a(ap2, apMac, ami);
                ap2.setAdoptStatus(0);
                this.a(ap2, controllerIdResult);
                this.refreshAp(ap2);
            } else if (ap.getIp() == null) {
                CacheTask.a.a(apMac);
                this.a(ap, apMac, ami);
                ae.debug("AP {} is wireless reachable", (Object)ap.getMac());
                if (ami.getWirelessLinked().booleanValue()) {
                    ap.setStatusWireless(Integer.valueOf(2));
                }
                this.a(ap, controllerIdResult);
                this.refreshAp(ap);
            } else if (!ap.getIp().equals(ami.getIp()) || !ap.getVersion().equals(ami.getVersion())) {
                CacheTask.a.a(apMac);
                ap.setIp(ami.getIp());
                ap.setLongIp(com.tp_link.eap.util.a.e.b((String)ami.getIp()));
                ap.setUptime(ami.getUptime());
                ap.setVersion(ami.getVersion());
                ap.setLastSeen(ami.getLastSeen());
                if (ami.getWirelessLinked().booleanValue()) {
                    ap.setStatusWireless(Integer.valueOf(2));
                }
                this.a(ap, controllerIdResult);
                this.refreshAp(ap);
            } else {
                ae.debug("CacheTask.cacheStore.cache");
                if (ap.getStatus() == 2) {
                    CacheTask.a.a(apMac, ami);
                }
            }
        }
        return true;
    }

    private void a(Ap ap, int n2) {
        if (n2 > 0) {
            ap.setManagedMark(n2);
        }
    }

    private void a(Ap ap, String string, ApMonitorInfo apMonitorInfo) {
        ap.setAdopted(false);
        ap.setStatus(Integer.valueOf(2));
        ap.setIp(apMonitorInfo.getIp());
        ap.setLongIp(com.tp_link.eap.util.a.e.b((String)apMonitorInfo.getIp()));
        ap.setMac(string);
        ap.setLastSeen(apMonitorInfo.getLastSeen());
        ap.setName(string);
        ap.setModel(apMonitorInfo.getModel());
        ap.setModelVersion(ModelVersionAdjustment.adjustModelVersion((String)apMonitorInfo.getModel(), (String)apMonitorInfo.getModelVersion()));
        ap.setModelModelVersion(apMonitorInfo.getModelModelVersion());
        ap.setHwVersion(apMonitorInfo.getHwVersion());
        ap.setUptime(apMonitorInfo.getUptime());
        ap.setVersion(apMonitorInfo.getVersion());
        ap.setDeviceMisc(apMonitorInfo.getDeviceMisc());
        ap.setWirelessLinked(apMonitorInfo.getWirelessLinked());
        boolean bl = ModelCache.firmwareCompatible((ApMonitorInfo)apMonitorInfo);
        ae.debug("firmware compatible {} for mac {}", (Object)bl, (Object)string);
        ap.setNeedUpgrade(Boolean.valueOf(!bl));
        com.tp_link.eap.monitor.monitor.realtime.c.a(string, bl);
        ap.setLocation(new Location(false, false, null, 0.0, 0.0));
    }

    @Override
    public boolean cacheAp(String apMac, ApMonitorInfo ami, StatCurrentAp sca, List<Client> apClients, List<StatCurrentSsid> scss, List<RogueAp> ras, List<LogInfo> logs, long lastSeenMs) {
        if (apMac == null || ami == null) {
            return false;
        }
        CacheTask.a.a(apMac, ami, sca, apClients, scss, ras, logs, lastSeenMs);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshAp(String apMac, ApMonitorInfo ami, StatCurrentAp sca, List<StatCurrentSsid> scss, List<LogInfo> apLogs, boolean isFirstInfom, ClientConnection clientConnection) {
        Object object;
        if (apMac == null || ami == null) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap == null) {
                ae.debug("failed to get AP info for mac : " + apMac);
            } else {
                String string;
                if (com.tp_link.eap.d.b.e((String)apMac) == null && ap.getStatus() != 2) {
                    ae.debug("ap is forgot or moved to other site, this inform is outOfDay.");
                    return true;
                }
                ap.setLastSeen(ami.getLastSeen());
                ap.setUptime(ami.getUptime());
                ap.setVersion(ami.getVersion());
                ap.setModelVersion(ModelVersionAdjustment.adjustModelVersion((String)ami.getModel(), (String)ami.getModelVersion()));
                if (!StringUtils.isBlank((String)ami.getSpecialModel())) {
                    string = ModelVersionAdjustment.adjustModelVersion((String)ami.getSpecialModel(), (String)ami.getModelVersion());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(ami.getSpecialModel());
                    stringBuilder.append(" ");
                    stringBuilder.append(string);
                    ap.setModelModelVersion(stringBuilder.toString());
                } else if (ap.getDeviceMisc() != null) {
                    string = ap.getDeviceMisc();
                    String string2 = ModelVersionAdjustment.adjustModelVersion((String)ami.getModel(), (String)ami.getModelVersion());
                    ap.setModelModelVersion(ModelModelVersionGenerator.generate((String)ami.getModel(), (int)string.getCustomizeRegion(), (String)string2));
                }
                ap.setHwVersion(ami.getHwVersion());
                ap.setWirelessLinked(ami.getWirelessLinked());
                if (!isFirstInfom) {
                    if (clientConnection != null) {
                        ap.setClientNum2g(clientConnection.a(ap.getMac(), 0));
                        ap.setClientNum5g(clientConnection.a(ap.getMac(), 1));
                        ap.setClientNum(ap.getClientNum2g() + ap.getClientNum5g());
                    } else {
                        ae.error("Invalid input, clientConnection is null");
                    }
                } else {
                    ae.debug("isFirstInfom, clientNum is {}", (Object)ap.getClientNum());
                }
                if (ap.getStatus() != 2 && com.tp_link.eap.d.b.e((String)apMac) != null) {
                    ap.setSite(com.tp_link.eap.d.b.e((String)apMac));
                }
                ami.setDeviceMisc(ap.getDeviceMisc());
                boolean bl = ModelCache.firmwareCompatible((ApMonitorInfo)ami);
                ap.setNeedUpgrade(Boolean.valueOf(!bl));
                com.tp_link.eap.monitor.monitor.realtime.c.a(apMac, bl);
                if (!com.tp_link.eap.util.a.e.a((String)ami.getIp())) {
                    ap.setIp(ami.getIp());
                    ap.setLongIp(com.tp_link.eap.util.a.e.b((String)ami.getIp()));
                }
                if (isFirstInfom) {
                    ap.setRealtimeStatus(RealtimeStatus.a.a());
                    if (com.tp_link.eap.monitor.monitor.realtime.a.a(apMac) != null) {
                        ap.setAdoptInfo(com.tp_link.eap.monitor.monitor.realtime.a.a(apMac));
                        com.tp_link.eap.monitor.monitor.realtime.a.b(apMac);
                    }
                    if (ap.getStatus() == 2) {
                        ap.setAdopted(true);
                        ap.setAdoptStatus(3);
                        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_FORGET, null, null, apMac);
                    }
                }
                if (ap.getStatus() != 2 && null != sca) {
                    ap.setCoverage(this.a(ami.getWp2g(), ami.getWp5g()));
                    if (com.tp_link.eap.util.l.d((DeviceMisc)ap.getDeviceMisc())) {
                        this.G.handleChannelChange(ap.getMac(), ami.getWp2g(), ami.getWp5g());
                    }
                    ap.setWp2g(ami.getWp2g());
                    ap.setWp5g(ami.getWp5g());
                    com.tp_link.eap.a.b.a((Ap)ap, (StatCurrentAp)sca);
                    if (ap.getStatus() == 0 || ap.getStatus() == 4) {
                        ap.setStatus(Integer.valueOf(1));
                    }
                    this.a(sca, scss, apLogs, apMac, ap.getClientNum());
                }
                this.refreshAp(ap);
            }
        }
        return true;
    }

    private void a(StatCurrentAp statCurrentAp, List<StatCurrentSsid> list, List<LogInfo> list2, String string, int n2) {
        this.q.refreshCurrentApStat(statCurrentAp, n2);
        this.q.refreshCurrentSsidStat(string, list);
        this.t.refreshLogs(string, list2);
    }

    @Override
    public boolean refreshAps() {
        ConcurrentHashMap<String, com.tp_link.eap.monitor.monitor.cache.b> concurrentHashMap = CacheTask.a.a();
        if (ae.isDebugEnabled()) {
            ae.debug("caMap:{}", CacheTask.a.a());
        }
        ConcurrentHashMap<String, Client> concurrentHashMap2 = CacheTask.a.b();
        ConcurrentHashMap<String, RogueAp> concurrentHashMap3 = CacheTask.a.c();
        ConcurrentHashMap<String, Guest> concurrentHashMap4 = CacheTask.a.d();
        if (ae.isTraceEnabled()) {
            ae.trace("clientMap:{}", concurrentHashMap2);
            ae.trace("raMap:{}", concurrentHashMap3);
        }
        ClientConnection clientConnection = new ClientConnection();
        ArrayList<String> arrayList = new ArrayList<String>(concurrentHashMap.keySet());
        this.r.refreshClients(concurrentHashMap2, arrayList, concurrentHashMap, clientConnection);
        this.u.refreshRogueAps(new ArrayList<RogueAp>(concurrentHashMap3.values()));
        this.s.refreshGuest(concurrentHashMap4);
        this.a(concurrentHashMap2, arrayList);
        if (!concurrentHashMap.isEmpty()) {
            for (Map.Entry<String, com.tp_link.eap.monitor.monitor.cache.b> entry : concurrentHashMap.entrySet()) {
                com.tp_link.eap.monitor.monitor.cache.b b2 = entry.getValue();
                String string = entry.getKey();
                this.refreshAp(string, b2.a(), b2.b(), b2.c(), b2.d(), false, clientConnection);
            }
        }
        this.d(arrayList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshAp(Ap ap) {
        Object object;
        ae.debug("save ap for mac: {}", (Object)ap.getMac());
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
        synchronized (object2) {
            this.i.save(ap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setName(String apId, String name) {
        Object object;
        if (com.tp_link.eap.util.a.e.a((String)apId) || com.tp_link.eap.util.a.e.a((String)name)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            ap.setName(name);
            this.refreshAp(ap);
            this.r.changeConnectedApName(ap.getMac(), name);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setRadio(Radio radio, boolean restore) {
        Object object;
        if (radio == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (radio.getApId() == null || radio.getRadioId() < 0 || radio.getRadioId() > 2) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)radio.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        boolean bl = radio.getRadioId() == 0;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            if (bl) {
                if (!radio.isRadioEnable()) {
                    ap.getRadio().setRadioEnable(false);
                } else {
                    ap.setRadio(radio);
                }
            } else if (!radio.isRadioEnable()) {
                ap.getRadio5g().setRadioEnable(false);
            } else {
                ap.setRadio5g(radio);
            }
            this.refreshAp(ap);
        }
        radio = bl ? ap.getRadio() : ap.getRadio5g();
        if (!restore) {
            object2 = new WirelessBasicConfig();
            object2.setChannel(Integer.valueOf(radio.getChannel()));
            object2.setChanWidth(Integer.valueOf(radio.getChannelWidth()));
            object2.setTxPower(radio.getTxPower());
            object2.setWirelessMode(Integer.valueOf(radio.getRadioMode()));
            object2.setRadioEnable(Boolean.valueOf(radio.isRadioEnable()));
            object2.setRadioId(Integer.valueOf(bl ? 0 : 1));
            object2.setChannelLimit(Boolean.valueOf(radio.isChannelLimitEnable()));
            if (object2.getWirelessMode() == 2 && !bl) {
                object2.setWirelessMode(Integer.valueOf(6));
            }
            if (bl) {
                this.w.refreshRecord(ap.getMac(), "wirelessBasic_2G", object2);
            } else {
                this.w.refreshRecord(ap.getMac(), "wirelessBasic_5G", object2);
            }
            this.G.clearApRoamingInfo(ap.getMac(), true);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setIpSetting(IpSetting ipSetting, boolean restore, boolean lanSetting_IpChange) {
        Object object;
        if (ipSetting == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)ipSetting.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            ap.setIpSetting(ipSetting);
            this.refreshAp(ap);
        }
        if (!restore) {
            object2 = com.tp_link.eap.a.a.a((IpSetting)ipSetting);
            if (lanSetting_IpChange) {
                this.w.refreshRecord(ap.getMac(), "lanSettingIpChange", object2);
            } else {
                this.w.refreshRecord(ap.getMac(), "lanSetting", object2);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setLanPortSettings(String apId, List<LanPortSetting> lanPortSettings) {
        Object object;
        if (lanPortSettings == null || com.tp_link.eap.util.a.e.a((String)apId)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            ae.warn("Failed to find ap {}", (Object)apId);
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.i.findByMac(string);
            if (ap == null) {
                ae.warn("Failed to find ap {}", (Object)apId);
                return new OperationResponse(ResErrorCode.Z);
            }
            List list = ap.getLanPortSettings();
            block3: for (LanPortSetting lanPortSetting : lanPortSettings) {
                for (LanPortSetting lanPortSetting2 : list) {
                    if (!lanPortSetting2.getLanPort().equals(lanPortSetting.getLanPort())) continue;
                    if (lanPortSetting2.getSupportVlan().booleanValue()) {
                        if (!com.tp_link.eap.util.p.c.a((int)lanPortSetting.getLocalVlanId(), (int)1, (int)4094)) {
                            return new OperationResponse(ResErrorCode.dj);
                        }
                        lanPortSetting2.setLocalVlanEnable(lanPortSetting.getLocalVlanEnable());
                        lanPortSetting2.setLocalVlanId(lanPortSetting.getLocalVlanId());
                    }
                    if (!lanPortSetting2.getSupportPoe().booleanValue()) continue block3;
                    lanPortSetting2.setPoeOutEnable(lanPortSetting.getPoeOutEnable());
                    continue block3;
                }
            }
            ap.setLanPortSettings(list);
            this.refreshAp(ap);
        }
        if (com.tp_link.eap.util.l.a((Ap)ap)) {
            object2 = com.tp_link.eap.a.a.a((List)ap.getLanPortSettings());
            this.w.refreshRecord(ap.getMac(), "bindVlan", object2);
        } else if (com.tp_link.eap.util.l.a((DeviceMisc)ap.getDeviceMisc())) {
            object2 = com.tp_link.eap.a.a.b((List)ap.getLanPortSettings());
            this.w.refreshRecord(ap.getMac(), "bindVlans", object2);
        }
        if (com.tp_link.eap.util.l.b((DeviceMisc)ap.getDeviceMisc())) {
            object2 = com.tp_link.eap.a.a.c((List)ap.getLanPortSettings());
            this.w.refreshRecord(ap.getMac(), "lanPortSettings", object2);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setLoadBalance(LoadBalance loadBalance, boolean restore) {
        Object object;
        if (loadBalance == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (loadBalance.getApId() == null || loadBalance.getRadioId() < 0 || loadBalance.getRadioId() > 2) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)loadBalance.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (loadBalance.getRadioId() == 0) {
                ap.setLoadBalance(loadBalance);
            } else if (loadBalance.getRadioId() == 1) {
                ap.setLoadBalance5g(loadBalance);
            }
            this.refreshAp(ap);
        }
        if (!restore) {
            object2 = new LoadBalanceConfig();
            object2.setEnable(Boolean.valueOf(loadBalance.isEnable()));
            object2.setMaxAssocClient(loadBalance.getMaxClients());
            object2.setRadioId(Integer.valueOf(loadBalance.getRadioId()));
            if (loadBalance.getRadioId() == 0) {
                this.w.refreshRecord(ap.getMac(), "loadBalance_2G", object2);
            } else {
                this.w.refreshRecord(ap.getMac(), "loadBalance_5G", object2);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setSsidOverride(SsidOverride ssid, boolean restore) {
        Object object;
        if (ssid == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (ssid.getApId() == null || ssid.getRadioId() < 0 || ssid.getRadioId() > 2) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)ssid.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        int n2 = -1;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            int n3;
            boolean bl;
            ap = this.getApDetail(string);
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            List<SsidOverride> list = new ArrayList();
            if (ssid.getRadioId() == 0) {
                list = ap.getSsidOverrides();
                if (list == null || list.isEmpty()) {
                    return new OperationResponse(ResErrorCode.d);
                }
            } else if (ssid.getRadioId() == 1 && ((list = ap.getSsidOverrides5g()) == null || list.isEmpty())) {
                return new OperationResponse(ResErrorCode.d);
            }
            if (!(bl = this.a(ssid, list))) {
                ae.debug("override info is not changed, no need to save to db.");
                return com.tp_link.eap.util.e.bd;
            }
            boolean bl2 = this.a(ssid.getGlobalSsid(), ssid.getSsid(), list);
            if (bl2) {
                return new OperationResponse(ResErrorCode.aw);
            }
            for (n3 = 0; n3 < list.size(); ++n3) {
                SsidOverride ssidOverride = list.get(n3);
                if (ssidOverride.getGlobalSsid() == null || !ssidOverride.getGlobalSsid().equals(ssid.getGlobalSsid())) continue;
                n2 = list.get(n3).getIndex();
                ssid.setIndex(n2);
                if (ssidOverride.isEnable()) {
                    ssid.setOldSsidName(ssidOverride.getSsid());
                } else {
                    ssid.setOldSsidName(ssidOverride.getGlobalSsid());
                }
                if (!ssid.isEnable()) {
                    Ssid ssid2 = this.v.getSsid(n2);
                    ssid.setSsid(ssid2.getName());
                    if (ssid2.getSecurityMode() == 3) {
                        ssid.setPsk(ssid2.getWirelessPasswordPsk());
                    }
                }
                list.set(n3, ssid);
                break;
            }
            if (n3 >= list.size() || n2 == -1) {
                return new OperationResponse(ResErrorCode.d);
            }
            this.G.clearApRoamingInfo(ap.getMac(), true);
            this.refreshAp(ap);
        }
        if (!restore) {
            this.a(ssid, n2, ap.getMac());
            this.s.delAllGuestByOverrideSsid(ap.getMac(), ssid.getIndex());
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setApStatus(String apId, Integer status) {
        Object object;
        if (apId == null || status < 0) {
            return false;
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            return false;
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            ap.setStatus(status);
            this.refreshAp(ap);
        }
        return true;
    }

    @Override
    public List<Ap> getAdoptAps() {
        return this.i.findByAdopted(true);
    }

    @Override
    public List<Ap> getSiteAdoptedAps(String site) {
        return this.i.findBySiteAndAdopted(site, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean locate(String apMac, Location location) {
        Object object;
        if (apMac == null || location == null) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap == null) {
                return false;
            }
            ap.setLocation(location);
            this.refreshAp(ap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unLocate(String apMac) {
        Object object;
        if (apMac == null) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap == null) {
                return false;
            }
            ap.getLocation().setLocated(false);
            ap.getLocation().setMapId(null);
            this.refreshAp(ap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String apMac, boolean lockStatus) {
        Object object;
        if (apMac == null) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap == null) {
                return false;
            }
            ap.getLocation().setLocked(lockStatus);
            this.refreshAp(ap);
        }
        return true;
    }

    @Override
    public List<Ap> getMapAps(String mapId) {
        if (mapId == null) {
            return null;
        }
        return this.i.findByLocation_mapId(mapId);
    }

    @Override
    public List<Ap> getUnLocatedAps() {
        List<Ap> list = this.i.findByLocation_located(false);
        if (!CollectionUtils.isEmpty(list)) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Ap ap = list.get(i2);
                if (ap.getSite() == null || ap.getSite().equals(com.tp_link.eap.d.b.a())) continue;
                list.remove(i2--);
            }
        }
        return list;
    }

    @Override
    public List<Ap> getApsByModel(String model) {
        if (model == null) {
            return null;
        }
        return this.i.findByModel(model);
    }

    @Override
    public List<Ap> getConnectedApsByModel(String model) {
        if (model == null) {
            return null;
        }
        return this.i.findByStatusAndModel(1, model);
    }

    @Override
    public List<Ap> getConnectedApsByModelModelVersion(String modelModelVersion) {
        if (modelModelVersion == null) {
            return null;
        }
        ae.debug("db findByStatusAndModelModelVersion modelModelVersion = " + modelModelVersion);
        return this.i.findByStatusAndModelModelVersion(1, modelModelVersion);
    }

    @Override
    public List<Ap> getConnectedAps() {
        return this.i.findByStatus(1);
    }

    @Override
    public List<Ap> getSiteConnectedAps(String site) {
        return this.i.findBySiteAndStatus(site, 1);
    }

    @Override
    public List<Ap> getDisconnectedAps() {
        return this.i.findByStatus(0);
    }

    @Override
    public List<Ap> getSiteDisconnectedAps(String site) {
        return this.i.findBySiteAndStatus(site, 0);
    }

    @Override
    public List<Ap> getSiteIsolatedAps(String site) {
        return this.i.findBySiteAndStatus(site, 4);
    }

    @Override
    public boolean refreshApUpdateStatus() {
        return true;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.i.countByFilters(filters, searchFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse reboot(String apId) {
        if (apId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.N);
        }
        if (ap.getStatus() == 0) {
            return new OperationResponse(ResErrorCode.O);
        }
        String string = ap.getMac();
        if (com.tp_link.eap.monitor.monitor.realtime.c.d(string)) {
            return new OperationResponse(ResErrorCode.P);
        }
        if (com.tp_link.eap.monitor.monitor.realtime.c.e(string)) {
            return new OperationResponse(ResErrorCode.Q);
        }
        if (com.tp_link.eap.monitor.monitor.realtime.c.f(string)) {
            return new OperationResponse(ResErrorCode.R);
        }
        if (com.tp_link.eap.monitor.monitor.realtime.c.g(string)) {
            return new OperationResponse(ResErrorCode.S);
        }
        this.ad.execute(new g(this, string, ap));
        int n2 = 0;
        while (!com.tp_link.eap.monitor.monitor.realtime.c.h(string) && n2 < 10) {
            try {
                Thread.sleep(500L);
                ++n2;
            }
            catch (InterruptedException interruptedException) {
                ae.warn("get an exception while wating reboot result for mac : " + string, (Throwable)interruptedException);
            }
        }
        if (!com.tp_link.eap.monitor.monitor.realtime.c.h(string) && n2 >= 10) {
            Object object;
            com.tp_link.eap.monitor.a.a.a(EventType.EVENT_REBOOT_TIMEOUT, null, null, string);
            Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
            synchronized (object2) {
                CacheTask.a.a(string);
                Ap ap2 = this.getApDetail(string);
                ap2.setStatus(Integer.valueOf(0));
                ap2.setRealtimeStatus(RealtimeStatus.g.a());
                this.refreshAp(ap2);
            }
            return new OperationResponse(ResErrorCode.T);
        }
        com.tp_link.eap.monitor.monitor.realtime.c.a(string, RealtimeStatus.b);
        this.setApRealtimeStatus(string, RealtimeStatus.b);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse upgrade(List<String> upgradeMacList, byte[] binFile, String site, String modelModelVersion) {
        Map<Integer, Set<String>> map;
        String string;
        if (CollectionUtils.isEmpty(upgradeMacList) || binFile == null || modelModelVersion != null && StringUtils.isEmpty((String)site)) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = null;
        if (modelModelVersion == null) {
            assert (upgradeMacList.size() == 1);
            String string2 = upgradeMacList.get(0);
            if (com.tp_link.eap.monitor.monitor.realtime.c.e(string2)) {
                operationResponse = new OperationResponse(ResErrorCode.db);
            } else if (com.tp_link.eap.monitor.monitor.realtime.c.d(string2)) {
                operationResponse = new OperationResponse(ResErrorCode.dc);
            } else if (com.tp_link.eap.monitor.monitor.realtime.c.f(string2)) {
                operationResponse = new OperationResponse(ResErrorCode.dd);
            } else if (com.tp_link.eap.monitor.monitor.realtime.c.g(string2)) {
                operationResponse = new OperationResponse(ResErrorCode.de);
            }
        } else if (com.tp_link.eap.monitor.monitor.realtime.d.b(site, modelModelVersion)) {
            operationResponse = new OperationResponse(ResErrorCode.br, "AP of model & ModelVersion " + modelModelVersion + " is upgrading, can not upgrade again.", null);
        }
        if (operationResponse != null) {
            return operationResponse;
        }
        if (modelModelVersion != null) {
            com.tp_link.eap.monitor.monitor.realtime.d.a(site, modelModelVersion, RealtimeStatus.c);
        }
        for (int i2 = 0; i2 < upgradeMacList.size(); ++i2) {
            string = upgradeMacList.get(i2);
            Map<Integer, Set<String>> map2 = map = com.tp_link.eap.b.b.a.a((String)string);
            synchronized (map2) {
                if (com.tp_link.eap.monitor.monitor.realtime.c.c(string)) {
                    com.tp_link.eap.monitor.monitor.realtime.c.a(string, RealtimeStatus.c);
                    this.setApRealtimeStatus(string, RealtimeStatus.c);
                    if (modelModelVersion == null) {
                        SingleUpgradeResult.a(string);
                    }
                } else {
                    upgradeMacList.remove(i2);
                    --i2;
                }
                continue;
            }
        }
        if (upgradeMacList.isEmpty()) {
            com.tp_link.eap.monitor.monitor.realtime.d.a(site, modelModelVersion);
            if (modelModelVersion == null) {
                return new OperationResponse(ResErrorCode.dg);
            }
            return new OperationResponse(ResErrorCode.dh);
        }
        List<String> list = upgradeMacList;
        string = new UpgradeMsg();
        string.setFileContent(binFile);
        string.setMacList(list);
        map = this.E.getHopMap(upgradeMacList);
        boolean bl = false;
        for (Integer object2 : map.keySet()) {
            if (object2 <= 0) continue;
            bl = true;
        }
        if (bl) {
            this.a(map, binFile);
        } else {
            this.ad.execute(new h(this, (UpgradeMsg)string));
        }
        com.tp_link.eap.monitor.monitor.upgrade.e e2 = new com.tp_link.eap.monitor.monitor.upgrade.e();
        e2.a(list);
        this.ad.execute(e2);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new i(this, site, list, binFile, modelModelVersion, e2));
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setApRogueStatus(String apId, boolean status, boolean restore) {
        Object object;
        if (apId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            ap.setRogueStatus(status);
            this.refreshAp(ap);
        }
        if (!restore) {
            object2 = new RogueApGlobal();
            object2.setEnable(Boolean.valueOf(status));
            this.w.refreshRecord(string, "rogueApGlobal", object2);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setApRealtimeStatus(String apMac, RealtimeStatus realtimeStatus) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap == null) {
                ae.info("AP to set is null.");
                return false;
            }
            ap.setRealtimeStatus(realtimeStatus.a());
            this.i.save(ap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApAdoptStatus(String apMac, int adoptStatus) {
        Object object;
        if (adoptStatus == 2) {
            com.tp_link.eap.util.b.g((String)apMac);
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap != null) {
                ap.setAdoptStatus(adoptStatus);
                this.i.save(ap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatusWireless(String apMac, int statusWireless) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(apMac);
            if (ap != null) {
                ap.setStatusWireless(Integer.valueOf(statusWireless));
                this.i.save(ap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAllSsidOverrides() {
        List<Ap> list = this.getAdoptAps();
        if (!CollectionUtils.isEmpty(list)) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object;
                Ap ap = list.get(i2);
                String string = ap.getMac();
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
                synchronized (object2) {
                    ap = this.getAp(ap.getId());
                    ap.setSsidOverrides(null);
                    ap.setSsidOverrides5g(null);
                    this.refreshAp(ap);
                    continue;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshApSsid(Ssid ssid, int operation) {
        if (ssid == null) {
            return false;
        }
        List<Ap> list = this.getSiteAndWlanAdoptedAps(com.tp_link.eap.d.b.a(), ssid.getWlanId());
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            Ap ap = list.get(i2);
            String string = ap.getMac();
            Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
            synchronized (object2) {
                int n2;
                List list2;
                ap = this.getApDetail(string);
                SsidOverride ssidOverride = new SsidOverride();
                if (operation == 1) {
                    ssidOverride.setIndex(ssid.getIdInt().intValue());
                    ssidOverride.setEnable(false);
                    ssidOverride.setGlobalSsid(ssid.getName());
                    ssidOverride.setRadioId(ssid.getRadioId());
                    ssidOverride.setSsid(ssid.getName());
                    ssidOverride.setPsk(ssid.getWirelessPasswordPsk());
                    ssidOverride.setVlanEnable(false);
                    ssidOverride.setVlanId(Integer.valueOf(0));
                    list2 = null;
                    if (ssid.getRadioId() == 0) {
                        if (CollectionUtils.isEmpty((Collection)ap.getSsidOverrides())) {
                            ap.setSsidOverrides(Collections.singletonList(ssidOverride));
                        } else {
                            ap.getSsidOverrides().add(ssidOverride);
                        }
                        list2 = ap.getSsidOverrides();
                    } else {
                        if (CollectionUtils.isEmpty((Collection)ap.getSsidOverrides5g())) {
                            ap.setSsidOverrides5g(Collections.singletonList(ssidOverride));
                        } else {
                            ap.getSsidOverrides5g().add(ssidOverride);
                        }
                        list2 = ap.getSsidOverrides5g();
                    }
                    this.refreshAp(ap);
                    if (!CollectionUtils.isEmpty(list2)) {
                        for (n2 = 0; n2 < list2.size(); ++n2) {
                            SsidOverride ssidOverride2 = (SsidOverride)list2.get(n2);
                            if (!ssid.getName().equals(ssidOverride2.getSsid()) || !ssidOverride2.isEnable()) continue;
                            ssidOverride2.setOldSsidName(ssidOverride2.getSsid());
                            Ssid ssid2 = this.v.getSsid(ssidOverride2.getIndex());
                            if (ssid2 != null) {
                                ssidOverride2.setSsid(ssid2.getName());
                                if (ssid2.getSecurityMode() == 3) {
                                    ssidOverride2.setPsk(ssid2.getWirelessPasswordPsk());
                                } else {
                                    ssidOverride2.setPsk(null);
                                }
                            } else {
                                ae.error("Failed to find ssid {} for {}", (Object)ssidOverride2.getIndex(), (Object)ssidOverride2.getGlobalSsid());
                                ssidOverride.setSsid("");
                            }
                            ssidOverride2.setEnable(false);
                            this.refreshAp(ap);
                            this.a(ssidOverride2, ssidOverride2.getIndex(), ap.getMac());
                            this.s.delAllGuestByOverrideSsid(ap.getMac(), ssidOverride2.getIndex());
                            break;
                        }
                    }
                    this.G.clearApRoamingInfo(string, true);
                } else if (operation == 2 || operation == 3) {
                    list2 = new ArrayList();
                    if (ssid.getRadioId() == 0) {
                        list2 = ap.getSsidOverrides();
                    } else if (ssid.getRadioId() == 1) {
                        list2 = ap.getSsidOverrides5g();
                    }
                    if (list2 != null && !list2.isEmpty()) {
                        for (n2 = 0; n2 < list2.size(); ++n2) {
                            ssidOverride = (SsidOverride)list2.get(n2);
                            if (ssidOverride.getIndex() == ssid.getIdInt().intValue()) {
                                if (operation == 3) {
                                    boolean bl = false;
                                    if (!ssidOverride.getGlobalSsid().equals(ssid.getName())) {
                                        ssidOverride.setGlobalSsid(ssid.getName());
                                        bl = true;
                                    }
                                    if (!ssidOverride.isEnable()) {
                                        ssidOverride.setSsid(ssid.getName());
                                        if (ssid.getSecurityMode() == 3) {
                                            ssidOverride.setPsk(ssid.getWirelessPasswordPsk());
                                        } else {
                                            ssidOverride.setPsk(null);
                                        }
                                        bl = true;
                                    }
                                    if (bl) {
                                        this.refreshAp(ap);
                                    }
                                } else {
                                    list2.remove(n2);
                                    this.refreshAp(ap);
                                    break;
                                }
                            }
                            if (!ssid.getName().equals(ssidOverride.getSsid()) || operation != 3 || !ssidOverride.isEnable()) continue;
                            ssidOverride.setOldSsidName(ssidOverride.getSsid());
                            Ssid ssid3 = this.v.getSsid(ssidOverride.getIndex());
                            if (ssid3 != null) {
                                ssidOverride.setSsid(ssid3.getName());
                                if (ssid3.getSecurityMode() == 3) {
                                    ssidOverride.setPsk(ssid3.getWirelessPasswordPsk());
                                } else {
                                    ssidOverride.setPsk(null);
                                }
                            } else {
                                ae.error("Failed to find ssid {} for {}", (Object)ssidOverride.getIndex(), (Object)ssidOverride.getGlobalSsid());
                                ssidOverride.setSsid("");
                            }
                            ssidOverride.setEnable(false);
                            this.refreshAp(ap);
                            this.a(ssidOverride, ssidOverride.getIndex(), ap.getMac());
                            this.s.delAllGuestByOverrideSsid(ap.getMac(), ssidOverride.getIndex());
                        }
                    }
                    this.G.clearApRoamingInfo(string, true);
                } else {
                    ae.warn("fail to sync ssid override info with ssid : " + ssid);
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    @Override
    public OperationResponse saveAssociationAp(Ap ap, boolean restore) {
        if (ap == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        this.refreshAp(ap);
        if (!restore) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ap.getId());
            SchedulerAssocAp schedulerAssocAp = this.z.b(arrayList);
            this.w.refreshRecord(ap.getMac(), "schedulerAssocAp", schedulerAssocAp);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private long a(List<StatCurrentAp> list) {
        long l2 = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            for (StatCurrentAp statCurrentAp : list) {
                long l3 = statCurrentAp.getTotalTraffic();
                if (com.tp_link.eap.monitor.monitor.cache.a.a(statCurrentAp.getApMac()) > 0L) {
                    l3 += com.tp_link.eap.monitor.monitor.cache.a.a(statCurrentAp.getApMac()).longValue();
                }
                if (com.tp_link.eap.monitor.monitor.cache.a.b(statCurrentAp.getApMac()) > 0L) {
                    l3 -= com.tp_link.eap.monitor.monitor.cache.a.b(statCurrentAp.getApMac()).longValue();
                }
                l2 += l3;
            }
        }
        return l2;
    }

    private void a(ConcurrentHashMap<String, Client> concurrentHashMap, List<String> list) {
        String string;
        ae.trace("refreshRAHourly");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object : list) {
            string = com.tp_link.eap.d.b.e((String)object);
            if (string == null) continue;
            hashMap.put(com.tp_link.eap.d.b.e((String)object), 0);
        }
        for (Client client : concurrentHashMap.values()) {
            string = client.getSite();
            if (hashMap.get(string) == null) {
                hashMap.put(string, 1);
                continue;
            }
            hashMap.put(string, (Integer)hashMap.get(string) + 1);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.a((String)entry.getKey(), (int)((Integer)entry.getValue()));
        }
    }

    private void a(String string, int n2) {
        long l2 = com.tp_link.eap.util.c.a.a();
        long l3 = com.tp_link.eap.util.c.a.b();
        long l4 = 0L;
        StatRAHourly statRAHourly = this.k.findByDaytimeAndSite(l2, string);
        List<StatCurrentAp> list = this.j.findBySite(string);
        if (statRAHourly == null) {
            com.tp_link.eap.monitor.monitor.cache.a.c();
            if (!CollectionUtils.isEmpty(list)) {
                for (StatCurrentAp statCurrentAp : list) {
                    com.tp_link.eap.monitor.monitor.cache.a.b(statCurrentAp.getApMac(), statCurrentAp.getTotalTraffic());
                }
            }
            if (!com.tp_link.eap.util.c.a.a((long)l3, (long)l2)) {
                this.a(string, l3);
            }
        }
        l4 = this.a(list);
        if (statRAHourly == null) {
            statRAHourly = new StatRAHourly(n2, l4, l2);
        } else {
            if (n2 > statRAHourly.getMaxClients()) {
                statRAHourly.setMaxClients(n2);
            }
            if (l4 > statRAHourly.getTraffic()) {
                statRAHourly.setTraffic(l4);
            }
        }
        statRAHourly.setSite(string);
        this.q.addStatRaHourly(statRAHourly);
    }

    private void a(String string, long l2) {
        long l3;
        int n2 = com.tp_link.eap.util.c.a.a((long)l2);
        long l4 = com.tp_link.eap.util.c.a.a((int)n2);
        List<StatRAHourly> list = this.k.get(string, l4, l3 = com.tp_link.eap.util.c.a.b((int)n2));
        if (list == null || list.isEmpty()) {
            ae.info("no ra hourly data in site : " + string + " " + l4 + " " + l3);
            return;
        }
        int n3 = this.b(list);
        long l5 = this.c(list);
        StatRADaily statRADaily = new StatRADaily(n3, l5, l4);
        statRADaily.setSite(string);
        this.q.addStatRaDaily(statRADaily);
    }

    private int b(List<StatRAHourly> list) {
        int n2 = list.get(0).getMaxClients();
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (list.get(i2).getMaxClients() <= n2) continue;
            n2 = list.get(i2).getMaxClients();
        }
        return n2;
    }

    private long c(List<StatRAHourly> list) {
        long l2 = list.get(0).getTraffic();
        for (int i2 = 1; i2 < list.size(); ++i2) {
            l2 += list.get(i2).getTraffic();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SsidOverride ssidOverride, int n2, String string) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            Ssid ssid = this.v.getSsid(n2);
            if (!ssidOverride.isEnable()) {
                this.v.saveSsid(ssid, 1, true, ssidOverride.getOldSsidName());
                return;
            }
            SsidC ssidC = this.z.a(ssid, 3);
            SsidConfig ssidConfig = new SsidConfig();
            ssidConfig.setRadioId(Integer.valueOf(ssidOverride.getRadioId()));
            ssidC.setSsidName(ssidOverride.getSsid());
            ssidC.setOldSsidName(ssidOverride.getOldSsidName());
            ssidC.setOverride(Boolean.valueOf(true));
            if (ssidOverride.isVlanEnable() && ssidOverride.getVlanId() != null) {
                ssidC.setVlanId(ssidOverride.getVlanId());
            }
            if (!com.tp_link.eap.util.a.e.a((String)ssidOverride.getPsk())) {
                int n3 = ssidC.getSecurityMode();
                if (n3 == 3) {
                    ssidC.setPskKey(ssidOverride.getPsk());
                }
            } else if (ssidC.getSecurityMode() == 3) {
                ssidC.setSecurityMode(Integer.valueOf(0));
            }
            ssidConfig.setSsid(Collections.singletonList(ssidC));
            this.w.refreshRecord(string, ssidOverride.getRadioId() == 0 ? "ssid_2G" : "ssid_5G", ssidConfig);
        }
    }

    private int a(WirelessParam wirelessParam, WirelessParam wirelessParam2) {
        int n2;
        int n3 = 0;
        if (wirelessParam != null && !wirelessParam.getActualChannel().trim().equals("N/A") && (n2 = (int)Math.pow(10.0, ((double)wirelessParam.getTxPower() + 24.0) / 26.0)) > n3) {
            n3 = n2;
        }
        if (wirelessParam2 != null && !wirelessParam2.getActualChannel().trim().equals("N/A") && (n2 = (int)Math.pow(10.0, ((double)wirelessParam2.getTxPower() + 14.0) / 26.0)) > n3) {
            n3 = n2;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(List<String> list) {
        int n2;
        List<Ap> list2 = this.i.findByStatus(2);
        List<Ap> list3 = this.i.findByStatus(1);
        List<Ap> list4 = this.i.findByStatus(4);
        if (!CollectionUtils.isEmpty(list4)) {
            for (Ap ap : list4) {
                if (System.currentTimeMillis() - ap.getLastSeen() <= 300000L) continue;
                this.handleDisconnectedAp(ap.getMac(), true);
            }
        }
        if (!CollectionUtils.isEmpty(list2)) {
            for (Ap ap : list2) {
                if (ap.getStatus() == 2 && ap.getAdoptStatus() == 2 && com.tp_link.eap.util.b.f((String)ap.getMac())) {
                    this.setApAdoptStatus(ap.getMac(), 0);
                }
                n2 = 0;
                if (ap.getWirelessLinked().booleanValue()) {
                    if (com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)60000L)) {
                        if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
                            n2 = 0;
                            if (com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)400000L)) {
                                n2 = 1;
                                ae.debug("handleUnreachableAps disconnectChildAp");
                                this.disconnectChildAp(ap.getMac(), true);
                            }
                        } else {
                            n2 = 1;
                        }
                        if (n2 != 0) {
                            this.E.deleteStatMeshInfo(ap.getMac());
                        }
                    }
                } else if (com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)120000L)) {
                    if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
                        ae.debug("deleteRelationship");
                        this.disconnectChildAp(ap.getMac(), true);
                    }
                    n2 = 1;
                    com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, ap.getMac());
                }
                if (n2 == 0) continue;
                ae.debug("deletePendingAp");
                this.deletePendingAp(ap.getMac());
            }
        }
        if (!CollectionUtils.isEmpty(list3)) {
            for (Ap ap : list3) {
                Object object;
                if (com.tp_link.eap.util.o.a.c((String)ap.getMac())) {
                    ae.debug("isSendingFile {}", (Object)ap.getMac());
                    continue;
                }
                if (com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)450000L)) {
                    ae.debug("handleDisconnectedAp {}", (Object)ap.getMac());
                    this.handleDisconnectedAp(ap.getMac(), true);
                    continue;
                }
                if (list.contains(ap.getMac())) continue;
                com.tp_link.eap.d.b.b((String)ap.getSite());
                n2 = (int)this.r.countApActiveClients(ap.getMac(), 0);
                int n3 = (int)this.r.countApActiveClients(ap.getMac(), 1);
                if (n2 == ap.getClientNum2g() && n3 == ap.getClientNum5g()) continue;
                ae.debug("clientNum of ap {} changed, old clientNum2g is {}, clientNum5g is {}", new Object[]{ap.getMac(), ap.getClientNum2g(), ap.getClientNum5g()});
                ae.debug("new clientNum2g is {}, clientNum5g is {}", (Object)n2, (Object)n3);
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
                synchronized (object2) {
                    Ap ap2 = this.getApByMac(ap.getMac());
                    ap2.setClientNum2g(n2);
                    ap2.setClientNum5g(n3);
                    ap2.setClientNum(n2 + n3);
                    this.i.save(ap2);
                    this.f(ap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDisconnectedAp(String mac, boolean needClear) {
        Object object;
        com.tp_link.eap.monitor.monitor.realtime.c.a(mac);
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)mac);
        synchronized (object2) {
            Ap ap = this.getApByMac(mac);
            ap.setStatus(Integer.valueOf(0));
            ap.setRealtimeStatus(RealtimeStatus.a.a());
            this.refreshAp(ap);
        }
        this.clearStatistics(mac);
        if (needClear && com.tp_link.eap.h.d.c.d((String)mac)) {
            com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, mac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDiscovery(String mac) {
        Object object;
        ae.debug("handleDiscovery");
        com.tp_link.eap.monitor.monitor.realtime.c.a(mac);
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)mac);
        synchronized (object2) {
            Ap ap = this.getApByMac(mac);
            ap.setRealtimeStatus(RealtimeStatus.a.a());
            this.refreshAp(ap);
        }
        this.clearStatistics(mac);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, mac);
    }

    @Override
    public OperationResult tkipAndWepCheck(int radioId, String checkType, String wlanId) {
        List<Ap> list;
        List<Ap> list2 = list = radioId == 0 ? this.i.findByAdoptedAndWlanGroupId2G(true, wlanId) : this.i.findByAdoptedAndWlanGroupId5G(true, wlanId);
        if (CollectionUtils.isEmpty(list)) {
            return com.tp_link.eap.util.e.bc;
        }
        if (radioId == 0) {
            for (Ap ap : list) {
                if (!ap.getRadio().getRadioMode().equals("2")) continue;
                if (checkType.equalsIgnoreCase("tkip")) {
                    return new OperationResult(false, "TKIP can't be in 11n only wireless mode.");
                }
                return new OperationResult(false, "SSIDs WEP security can't be in 11n only wireless mode.");
            }
        } else {
            for (Ap ap : list) {
                if (!com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) continue;
                String string = ap.getRadio5g().getRadioMode();
                if (string.equals("2")) {
                    if (checkType.equalsIgnoreCase("tkip")) {
                        return new OperationResult(false, "TKIP can't be in 11n only wireless mode.");
                    }
                    return new OperationResult(false, "SSIDs WEP security can't be in 11n only wireless mode.");
                }
                if (string.equals("8")) {
                    if (checkType.equalsIgnoreCase("tkip")) {
                        return new OperationResult(false, "TKIP can't be in 11ac only wireless mode.");
                    }
                    return new OperationResult(false, "SSIDs WEP security can't be in 11ac only wireless mode.");
                }
                if (!string.equals("9")) continue;
                if (checkType.equalsIgnoreCase("tkip")) {
                    return new OperationResult(false, "TKIP can't be in 11n/ac mixed wireless mode.");
                }
                return new OperationResult(false, "SSIDs WEP security can't be in 11n/ac mixed wireless mode.");
            }
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResponse qosCheck(int radioId) {
        List<Ap> list = this.getSiteAdoptedAps(com.tp_link.eap.d.b.a());
        if (CollectionUtils.isEmpty(list)) {
            return com.tp_link.eap.util.e.bd;
        }
        if (radioId == 0) {
            for (Ap ap : list) {
                String string = ap.getRadio().getRadioMode();
                if (!string.equals("2")) continue;
                return new OperationResponse(ResErrorCode.ai);
            }
        } else {
            for (Ap ap : list) {
                String string;
                if (!com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel()) || !(string = ap.getRadio5g().getRadioMode()).equals("2") && !string.equals("8") && !string.equals("9")) continue;
                return new OperationResponse(ResErrorCode.ba);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public List<Ap> getPendingAps() {
        return this.i.findByStatus(2);
    }

    private void a(String string, String string2, String string3, String string4, boolean bl) {
        ae.debug("doAdoptAp: {} {}", (Object)string, (Object)bl);
        AdoptInfo adoptInfo = new AdoptInfo(string3, string4);
        com.tp_link.eap.monitor.monitor.realtime.a.a(string, adoptInfo);
        Authentication authentication = new Authentication();
        authentication.setIp(string2);
        authentication.setMac(string);
        authentication.setUserName(string3);
        authentication.setPassword(string4);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_ADOPT, Authentication.class, authentication, string);
        ae.debug("EVENT_ADOPT end {}", (Object)string);
        com.tp_link.eap.monitor.monitor.realtime.a.f(string);
    }

    private void b(String string, String string2, String string3, String string4, boolean bl) {
        ae.debug("adoptApEachBatch: {} {}", (Object)string, (Object)bl);
        com.tp_link.eap.util.b.c((String)string);
        AdoptInfo adoptInfo = new AdoptInfo(string3, string4);
        com.tp_link.eap.monitor.monitor.realtime.a.a(string, adoptInfo);
        Authentication authentication = new Authentication();
        authentication.setIp(string2);
        authentication.setMac(string);
        authentication.setUserName(string3);
        authentication.setPassword(string4);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_ADOPT, Authentication.class, authentication, string);
        ae.debug("EVENT_ADOPT end {}", (Object)string);
        if (!bl) {
            com.tp_link.eap.monitor.monitor.realtime.a.f(string);
        } else {
            Ap ap;
            this.a(string, bl);
            com.tp_link.eap.monitor.monitor.realtime.a.f(string);
            if (!com.tp_link.eap.util.b.e((String)string) && (ap = this.i.findByMac(string)).getWirelessLinked().booleanValue()) {
                this.disconnectChildAp(string, false);
                this.E.refreshStatus(string, 3);
                this.setApAdoptStatus(string, 2);
                this.setStatusWireless(string, 1);
            }
        }
    }

    private int a(String string, boolean bl) {
        int n2;
        ae.debug("waitAdoptResult {}", (Object)string);
        int n3 = 0;
        int n4 = bl ? 12 : 10;
        int n5 = n2 = bl ? 2000 : 1000;
        while (!com.tp_link.eap.util.b.d((String)string) && n3 < n4) {
            ae.debug("while apMac: {} watiCount: {}", (Object)string, (Object)n3);
            try {
                Thread.sleep(n2);
                ++n3;
            }
            catch (InterruptedException interruptedException) {
                ae.warn("get an exception while waiting adopting result for mac : " + string, (Throwable)interruptedException);
            }
        }
        return n3;
    }

    @Override
    public OperationResponse batchAdopt(String username, String password) {
        List<Ap> list = this.getPendingAps();
        int n2 = this.b();
        if (!CollectionUtils.isEmpty(list)) {
            if (com.tp_link.eap.monitor.monitor.realtime.a.a()) {
                ae.debug("already batch adopting..");
                return new OperationResponse(ResErrorCode.U);
            }
            ae.debug("batchAdopt");
            String string = com.tp_link.eap.d.b.a();
            com.tp_link.eap.monitor.monitor.realtime.a.a(true);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(new j(this, string, n2, username, password));
            return new OperationResponse(ResErrorCode.a, "This operation will take a few minutes, please refresh to view the adopt result. Notice: The device which was managed by others will not be adopted.", null);
        }
        return new OperationResponse(ResErrorCode.V);
    }

    @Override
    public OperationResponse batchAdopt(List<Ap> apList, String username, String password) {
        if (!CollectionUtils.isEmpty(apList)) {
            if (!com.tp_link.eap.monitor.monitor.realtime.a.b()) {
                return new OperationResponse(ResErrorCode.U);
            }
            String string = com.tp_link.eap.d.b.a();
            com.tp_link.eap.monitor.monitor.realtime.a.a(true);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(new k(this, apList, string, username, password));
            return new OperationResponse(ResErrorCode.a, "This operation will take a few minutes, please refresh to view the adopt result. Notice: The device which was managed by others will not be adopted.", null);
        }
        return new OperationResponse(ResErrorCode.V);
    }

    private int b() {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"netty.properties");
        return Integer.parseInt(configuration.getProperty("batch.adopt.retry.times"));
    }

    private boolean e(List<String> list) {
        ae.debug("existAdoptUnfinishedAp");
        return DeviceContext.existConnectingDevice(list);
    }

    private int c() {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"netty.properties");
        return Integer.parseInt(configuration.getProperty("batch.adopt.thread.num"));
    }

    private int d() {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"netty.properties");
        return Integer.parseInt(configuration.getProperty("batch.adopt.frequency"));
    }

    private void a(String string, String string2, List<Ap> list, ExecutorService executorService) {
        String string3 = com.tp_link.eap.d.b.a();
        for (Ap ap : list) {
            if (MeshState.isConnecting((String)ap.getMac())) continue;
            executorService.execute(new l(this, string3, ap, string, string2));
            try {
                int n2 = this.d();
                if (ap.getWirelessLinked().booleanValue()) {
                    n2 = 2 * n2;
                }
                if (n2 <= 0) continue;
                TimeUnit.MILLISECONDS.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                ae.warn("Exception :", (Throwable)interruptedException);
            }
        }
    }

    @Override
    public boolean clearStatistics(String apMac) {
        this.r.disconnectClient(apMac);
        this.q.deleteSca(apMac);
        this.q.deleteScs(apMac);
        this.G.clearApRoamingInfo(apMac, false);
        return true;
    }

    @Override
    public void autoAdoptAp(String apMac, String ip, String username, String password, boolean wirelessLinked) {
        ae.debug("autoAdoptAp: " + apMac);
        this.a(apMac, ip, username, password, wirelessLinked);
    }

    private boolean a(String string, String string2, List<SsidOverride> list) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (SsidOverride ssidOverride : list) {
            if (!(ssidOverride.getGlobalSsid().equals(string) ? string2 != null && string2.equals(ssidOverride.getGlobalSsid()) : string2 != null && (string2.equals(ssidOverride.getGlobalSsid()) || string2.equals(ssidOverride.getSsid())))) continue;
            return true;
        }
        return false;
    }

    private boolean a(SsidOverride ssidOverride, List<SsidOverride> list) {
        for (SsidOverride ssidOverride2 : list) {
            if (ssidOverride.getGlobalSsid() == null || !ssidOverride2.getGlobalSsid().equals(ssidOverride.getGlobalSsid())) continue;
            if (ssidOverride.isEnable() != ssidOverride2.isEnable()) {
                return true;
            }
            if (ssidOverride.isEnable()) {
                if (ssidOverride.getSsid() != null && !ssidOverride.getSsid().equals(ssidOverride2.getSsid())) {
                    return true;
                }
                if (ssidOverride.getPsk() != null && !ssidOverride.getPsk().equals(ssidOverride2.getPsk())) {
                    return true;
                }
                if (ssidOverride.isVlanEnable() != ssidOverride2.isVlanEnable()) {
                    return true;
                }
                if (ssidOverride.isVlanEnable() && ssidOverride.getVlanId() != null && !ssidOverride.getVlanId().equals(ssidOverride2.getVlanId())) {
                    return true;
                }
            }
            return false;
        }
        ae.error("failed to get override info for ssid : " + ssidOverride.getGlobalSsid());
        return false;
    }

    @Override
    public Ap generateConfigAp(String apMac) {
        com.tp_link.eap.d.b.f((String)apMac);
        Ap ap = this.getApDetail(apMac);
        String string = com.tp_link.eap.util.j.a.a((Integer)ap.getDeviceMisc().getCustomizeRegion());
        if (string == null) {
            string = com.tp_link.eap.util.j.a.a((Integer)841);
        }
        ap.setStatus(Integer.valueOf(1));
        ap.setAdopted(true);
        ap.setAdoptStatus(3);
        ap.setRealtimeStatus(RealtimeStatus.f.a());
        ap.setLastSeen(System.currentTimeMillis());
        if (ap.getAdoptInfo() == null) {
            List<Object> list;
            ae.debug("init configuration for mac : " + apMac);
            ap.setSite(com.tp_link.eap.d.b.e((String)apMac));
            this.generateApRadioConfig(ap, ap.getDeviceMisc(), string);
            ap.setIpSetting(new IpSetting());
            ap.setRogueStatus(false);
            ap.setLoadBalance(new LoadBalance());
            ap.setLoadBalance5g(new LoadBalance());
            ap.setLanPortSettings(this.H.buildDefaultLanPortSettings(ap));
            if (com.tp_link.eap.util.e.c((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
                ap.setTrunkSetting(new TrunkSetting());
            }
            ap.setRssi(new RssiThreshold(false, 0));
            ap.setRssi5g(new RssiThreshold(false, 0));
            List<Ssid> list2 = this.v.getDefSsidsByRadioId(0);
            if (list2 != null) {
                list = new ArrayList();
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    list.add(new SsidOverride(list2.get(i2)));
                }
                ap.setSsidOverrides(list);
            }
            if ((list = this.v.getDefSsidsByRadioId(1)) != null) {
                ArrayList<SsidOverride> arrayList = new ArrayList<SsidOverride>();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    arrayList.add(new SsidOverride((Ssid)list.get(i3)));
                }
                ap.setSsidOverrides5g(arrayList);
            }
            WlanGroup wlanGroup = this.B.getDefWlanByRadioId(0);
            ap.setWlanGroupId2G(wlanGroup.getWlanId());
            ap.setWlan2g(wlanGroup.getName());
            wlanGroup = this.B.getDefWlanByRadioId(1);
            ap.setWlanGroupId5G(wlanGroup.getWlanId());
            ap.setWlan5g(wlanGroup.getName());
        } else {
            this.H.upgradeLanPortSettings(ap);
        }
        ap.setAdoptInfo(com.tp_link.eap.monitor.monitor.realtime.a.a(apMac));
        return ap;
    }

    @Override
    public void generateApRadioConfig(Ap adoptAp, DeviceMisc deviceMisc, String country) {
        Radio radio;
        QosSetting qosSetting;
        RegionWireParam regionWireParam = com.tp_link.eap.util.j.b.e((String)country, (boolean)true);
        RegionWireParam regionWireParam2 = com.tp_link.eap.util.j.b.e((String)country, (boolean)false);
        Integer n2 = deviceMisc.getMaxPower2G();
        Integer n3 = deviceMisc.getMaxPower5G();
        if (n2 == null) {
            n2 = regionWireParam.getMaxTxPower();
        }
        if (n3 == null) {
            n3 = regionWireParam2.getMaxTxPower();
        }
        if (null != (qosSetting = this.A.getQosSetting())) {
            adoptAp.setRadio(new Radio(0, n2.intValue(), regionWireParam.isSupport40(), qosSetting.getWmmEnable24().booleanValue(), com.tp_link.eap.util.e.b((DeviceMisc)deviceMisc, (String)adoptAp.getModel())));
            adoptAp.setRadio5g(new Radio(1, n3.intValue(), regionWireParam2.isSupport40(), qosSetting.getWmmEnable5().booleanValue(), com.tp_link.eap.util.e.b((DeviceMisc)deviceMisc, (String)adoptAp.getModel())));
        }
        if (com.tp_link.eap.util.j.b.d((String)country) && com.tp_link.eap.util.e.b((DeviceMisc)adoptAp.getDeviceMisc(), (String)adoptAp.getModel()) && null != (radio = adoptAp.getRadio5g())) {
            radio.setChannelWidth(String.valueOf(6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setRssi(RssiThreshold rssi, boolean restore) {
        Object object;
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)rssi.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            if (rssi.getRadioId() == 0) {
                ap.setRssi(rssi);
            } else if (rssi.getRadioId() == 1) {
                ap.setRssi5g(rssi);
            }
            this.refreshAp(ap);
        }
        if (!restore) {
            object2 = new RadioRssi();
            object2.setEnable(Boolean.valueOf(rssi.isEnable()));
            object2.setThreshold(Integer.valueOf(rssi.getThreshold()));
            if (rssi.getRadioId() == 0) {
                this.w.refreshRecord(ap.getMac(), "rssi_2G", object2);
            } else {
                this.w.refreshRecord(ap.getMac(), "rssi_5G", object2);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public String getApIp(String apMac) {
        Query query = new Query();
        query.fields().include("ip");
        query.addCriteria(Criteria.where((String)"mac").is((Object)apMac));
        Ap ap = (Ap)this.p.findOne(query, Ap.class);
        if (ap == null) {
            return null;
        }
        return ap.getIp();
    }

    @Override
    public String getSiteByApMac(String apMac) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"mac").is((Object)apMac));
        query.fields().include("site");
        Ap ap = (Ap)this.p.findOne(query, Ap.class);
        if (ap != null) {
            return ap.getSite();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setWlanGroup(String apId, int radioId, String wlanId, boolean sendMsg) {
        Object object;
        Object object2;
        Object object32;
        List<Object> list;
        if (apId == null || wlanId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)apId));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getSite();
        if (radioId == 0 && ap.getWlanGroupId2G().equals(wlanId)) {
            return com.tp_link.eap.util.e.bd;
        }
        if (radioId == 1 && ap.getWlanGroupId5G().equals(wlanId)) {
            return com.tp_link.eap.util.e.bd;
        }
        WlanGroup wlanGroup = this.B.getWlanGroup(wlanId);
        if (wlanGroup == null) {
            ae.debug("WLAN group doesn't exist");
            return new OperationResponse(ResErrorCode.dv);
        }
        String string2 = wlanGroup.getSite();
        if (!string.equals(string2)) {
            ae.debug("Not allowed to apply WLAN Group to an AP which belongs to a different site!");
            return new OperationResponse(ResErrorCode.dw);
        }
        List<Ssid> list2 = this.v.getSsidsByRadioIdAndWlanId(radioId, wlanId);
        Radio radio = radioId == 0 ? ap.getRadio() : ap.getRadio5g();
        OperationResponse operationResponse = this.v.checkApRadioMode(Integer.parseInt(radio.getRadioMode()), radioId, wlanId);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (sendMsg && !CollectionUtils.isEmpty(list = this.v.getSsidsByRadioIdAndWlanId(radioId, radioId == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G()))) {
            for (Object object32 : list) {
                if (!object32.getSite().equals(com.tp_link.eap.d.b.a())) {
                    ae.debug("SSID site doesn't match thread site, cannot set WLAN Group.");
                    return com.tp_link.eap.util.e.aZ;
                }
                arrayList.add(object32.getId());
            }
        }
        list = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (!CollectionUtils.isEmpty(list2)) {
            object32 = list2.iterator();
            while (object32.hasNext()) {
                object2 = (Ssid)object32.next();
                object = new SsidOverride();
                object.setIndex(object2.getIdInt().intValue());
                object.setEnable(false);
                object.setGlobalSsid(object2.getName());
                object.setRadioId(object2.getRadioId());
                object.setSsid(object2.getName());
                object.setPsk(object2.getWirelessPasswordPsk());
                object.setVlanEnable(false);
                object.setVlanId(Integer.valueOf(0));
                list.add(object);
                arrayList2.add(object2.getId());
            }
        }
        object2 = object32 = com.tp_link.eap.b.b.a.a((String)ap.getMac());
        synchronized (object2) {
            ap = (Ap)this.i.findOne((Serializable)((Object)apId));
            if (radioId == 0) {
                object = ap.getSsidOverrides();
                ap.setWlanGroupId2G(wlanId);
                ap.setWlan2g(wlanGroup.getName());
                ap.setSsidOverrides(list);
            } else {
                object = ap.getSsidOverrides5g();
                ap.setWlanGroupId5G(wlanId);
                ap.setWlan5g(wlanGroup.getName());
                ap.setSsidOverrides5g(list);
            }
            if (this.refreshAp(ap)) {
                if (sendMsg) {
                    ae.debug("set wlan group, send ssids and rate limits, " + ap.getMac());
                    this.a(ap.getMac(), radioId, arrayList, arrayList2, (List<SsidOverride>)object);
                    for (Ssid ssid : list2) {
                        SsidRateLimit ssidRateLimit = this.z.a((int)ssid.getIdInt(), ssid.getRateLimit(), ssid.getName(), ssid.getRadioId());
                        this.v.refreshRateLimitRecordByAp(ap, ssidRateLimit, radioId);
                    }
                }
                this.G.clearApRoamingInfo(ap.getMac(), true);
                OperationResponse operationResponse2 = new OperationResponse(ResErrorCode.a, (Object)ap);
                operationResponse2.setMsg("Set wlan group successfully.");
                return operationResponse2;
            }
            return new OperationResponse(ResErrorCode.b);
        }
    }

    private void a(String string, Integer n2, List<String> list, List<String> list2, List<SsidOverride> list3) {
        ArrayList<SsidC> arrayList;
        List list4;
        if (string == null || n2 == null) {
            return;
        }
        SsidConfig ssidConfig = this.z.a(2, n2, list);
        SsidConfig ssidConfig2 = this.z.a(1, n2, list2);
        if (ssidConfig != null && !CollectionUtils.isEmpty((Collection)(list4 = ssidConfig.getSsid()))) {
            for (SsidC ssidC : list4) {
                ssidC.setSsidName(this.a(ssidC, list3));
                arrayList = new ArrayList();
                arrayList.add(ssidC);
                ssidConfig.setSsid(arrayList);
                this.w.refreshRecord(string, n2 == 0 ? "ssid_2G" : "ssid_5G", ssidConfig);
            }
        }
        if (ssidConfig2 != null && !CollectionUtils.isEmpty((Collection)(list4 = ssidConfig2.getSsid()))) {
            for (SsidC ssidC : list4) {
                arrayList = new ArrayList<SsidC>();
                arrayList.add(ssidC);
                ssidConfig2.setSsid(arrayList);
                this.w.refreshRecord(string, n2 == 0 ? "ssid_2G" : "ssid_5G", ssidConfig2);
            }
        }
    }

    private String a(SsidC ssidC, List<SsidOverride> list) {
        if (CollectionUtils.isEmpty(list) || ssidC == null) {
            if (ssidC == null) {
                return null;
            }
            return ssidC.getSsidName();
        }
        for (SsidOverride ssidOverride : list) {
            if (ssidOverride.getIndex() != ssidC.getId().intValue()) continue;
            if (ssidOverride.isEnable()) {
                return ssidOverride.getSsid();
            }
            return ssidOverride.getGlobalSsid();
        }
        return ssidC.getSsidName();
    }

    @Override
    public List<Ap> getSiteAndWlanAdoptedAps(String site, String wlanId) {
        WlanGroup wlanGroup = this.B.getWlanGroup(wlanId);
        if (wlanGroup == null) {
            return null;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)site));
        if (wlanGroup.getRadioId() == 0) {
            query.addCriteria(Criteria.where((String)"wlanGroupId2G").is((Object)wlanId));
        } else {
            query.addCriteria(Criteria.where((String)"wlanGroupId5G").is((Object)wlanId));
        }
        return this.p.find(query, Ap.class);
    }

    @Override
    public void deleteApStats(String apMac, String site) {
        this.clearStatistics(apMac);
        com.tp_link.eap.d.b.b((String)site);
        this.t.deleteLogs(apMac);
        this.C.deleteByApAndSite(apMac, site);
    }

    @Override
    public Ap getWlanGroupIdByMac(String apMac) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"mac").is((Object)apMac));
        query.fields().include("wlanGroupId2G").include("wlanGroupId5G").include("wlan2g").include("wlan5g");
        Ap ap = (Ap)this.p.findOne(query, Ap.class);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setTrunkSetting(TrunkSetting trunkSetting, boolean restore) {
        Object object;
        if (trunkSetting == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = (Ap)this.i.findOne((Serializable)((Object)trunkSetting.getApId()));
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            ap.setTrunkSetting(trunkSetting);
            this.refreshAp(ap);
        }
        if (!restore) {
            object2 = com.tp_link.eap.a.a.a((TrunkSetting)trunkSetting);
            this.w.refreshRecord(ap.getMac(), "trunkConfig", object2);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public List<Ap> getApWithWlanGroup(String wlanId, Integer radioId) {
        if (!com.tp_link.eap.util.a.e.a((String)wlanId)) {
            switch (radioId) {
                case 0: {
                    return this.i.findByAdoptedAndWlanGroupId2G(true, wlanId);
                }
                case 1: {
                    return this.i.findByAdoptedAndWlanGroupId5G(true, wlanId);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public List<Ap> getApNeedToUpgrade() {
        String string = com.tp_link.eap.d.b.a();
        if (string == null) {
            return null;
        }
        return this.i.findBySiteAndStatusAndNeedUpgrade(string, 1, true);
    }

    @Override
    public Boolean checkIpChange(IpSetting oldIpSetting, IpSetting ipSetting) {
        boolean bl = false;
        if (!oldIpSetting.getMode().equals(ipSetting.getMode())) {
            bl = true;
        } else if (!(!oldIpSetting.getMode().equals("static") || oldIpSetting.getConfigIp().equals(ipSetting.getConfigIp()) && oldIpSetting.getConfigMask().equals(ipSetting.getConfigMask()) && oldIpSetting.getConfigGate().equals(ipSetting.getConfigGate()))) {
            bl = true;
        } else if (!(!oldIpSetting.getMode().equals("dhcp") || oldIpSetting.getFallbackIp().equals(ipSetting.getFallbackIp()) && oldIpSetting.getFallbackMask().equals(ipSetting.getFallbackMask()) && oldIpSetting.isFallback() == ipSetting.isFallback())) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refreshApCredential(String mac) {
        Ap ap = this.i.findByMac(mac);
        if (!com.tp_link.eap.util.l.c((DeviceMisc)ap.getDeviceMisc())) return;
        MeshConf meshConf = ap.getMeshConf();
        if (meshConf != null) {
            ae.debug("update credential with mesh config");
            String string = meshConf.getParentApMac();
            if (com.tp_link.eap.util.a.e.a((String)string)) return;
            UserAccountSetting userAccountSetting = this.A.getUserAccountBySite(ap.getSite());
            if (userAccountSetting == null) return;
            String string2 = userAccountSetting.getUserName();
            String string3 = userAccountSetting.getPassword();
            this.E.sendAddCommand(string, mac, string2, string3);
            return;
        } else {
            ae.debug("Failed to get mesh config for {}", (Object)mac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWirelessPendingAp(IsolatedAP isolatedAP, int managedMark, String site) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)isolatedAP.getMac());
        synchronized (object2) {
            Ap ap = this.i.findByMac(isolatedAP.getMac());
            if (ap == null) {
                ap = new Ap();
                ap.setMac(isolatedAP.getMac());
                ap.setWirelessLinked(Boolean.valueOf(true));
                ap.setAdoptStatus(0);
                ap.setAdopted(false);
                ap.setStatus(Integer.valueOf(2));
                ap.setStatusWireless(Integer.valueOf(1));
                ap.setName(isolatedAP.getMac());
                ap.setModel(isolatedAP.getModel());
                ap.setModelVersion(isolatedAP.getModelVersion());
                ap.setLocation(new Location(false, false, null, 0.0, 0.0));
                ap.setLastSeen(System.currentTimeMillis());
                ap.setManagedMark(managedMark);
                DevCap devCap = new DevCap();
                devCap.setMeshChainNum(isolatedAP.getMeshChainNum());
                ap.setDevCap(devCap);
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(site);
                ap.setWirelessPendingSite(hashSet);
                this.refreshAp(ap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWirelessPendingAp(IsolatedAP isolatedAP, int managedMark, String site) {
        Object object;
        Ap ap = this.i.findByMac(isolatedAP.getMac());
        if (ap == null) {
            return;
        }
        if (ap.getStatus() != 2) {
            this.forgetAp(ap.getId());
            return;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)isolatedAP.getMac());
        synchronized (object2) {
            ap = this.i.findByMac(isolatedAP.getMac());
            if (ap != null) {
                ap.setMac(isolatedAP.getMac());
                ap.setWirelessLinked(Boolean.valueOf(true));
                if (com.tp_link.eap.util.a.e.a((String)ap.getName())) {
                    ap.setName(isolatedAP.getMac());
                }
                ap.setModel(isolatedAP.getModel());
                ap.setModelVersion(isolatedAP.getModelVersion());
                ap.setLocation(new Location(false, false, null, 0.0, 0.0));
                ap.setLastSeen(System.currentTimeMillis());
                ap.setManagedMark(managedMark);
                DevCap devCap = ap.getDevCap();
                devCap.setMeshChainNum(isolatedAP.getMeshChainNum());
                ap.setDevCap(devCap);
                HashSet<String> hashSet = ap.getWirelessPendingSite();
                if (CollectionUtils.isEmpty((Collection)hashSet)) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(site);
                ap.setWirelessPendingSite(hashSet);
                this.i.save(ap);
            }
        }
    }

    @Override
    public void doFailoverTask() {
        ae.debug("doFailoverTask");
        List<Ap> list = this.i.findByStatus(4);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                this.handleFailover(ap.getMac());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailover(String mac) {
        Object object;
        if (com.tp_link.eap.util.restore.c.g() != null && !com.tp_link.eap.util.restore.c.g().isFinished()) {
            ae.warn("Restore is progressing");
            return;
        }
        if (!com.tp_link.eap.util.l.a((long)MeshFailoverRecord.getIsolated((String)mac), (long)15000L)) {
            ae.debug("childMac {} need time to transfer stably isolated ", (Object)mac);
            return;
        }
        if (!MeshFailoverRecord.isChildIdle((String)mac)) {
            ae.debug("failover interval child: {}", (Object)mac);
            return;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.n((String)mac);
        synchronized (object2) {
            String string;
            MeshSetting meshSetting = this.A.getMeshSettingByMac(mac);
            if (meshSetting == null) {
                ae.warn("Fail to get mesh settings");
                return;
            }
            if (!meshSetting.isAutoFailoverEnable()) {
                return;
            }
            if (!MeshFailoverRecord.isChildIdle((String)mac)) {
                ae.debug("failover interval child: {}", (Object)mac);
                return;
            }
            MeshFailoverRecord.addChildRecord((String)mac);
            ae.debug("try Handle failover for " + mac);
            Ap ap = this.i.findByMac(mac);
            if (ap == null) {
                ae.warn("The failover ap is null");
                return;
            }
            if (ap.getStatus() != 4) {
                ae.debug("Not isolated possibly");
                return;
            }
            StatMeshInfo statMeshInfo = this.E.getStatMeshByMac(mac);
            if (statMeshInfo != null && statMeshInfo.getStatus() == 1) {
                ae.debug("Change parent is running");
                return;
            }
            if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)(string = ap.getMeshConf().getParentApMac())) && this.a(string, ap.getMac())) {
                ae.debug("Old parent AP {} is still available, wait for auto reconnect.", (Object)string);
                return;
            }
            string = ap.getSite();
            com.tp_link.eap.d.b.b((String)string);
            String string2 = ap.getMac();
            this.af.execute(new m(this, ap, string2, string));
        }
    }

    private boolean a(String string, String string2) {
        StatMeshInfo statMeshInfo;
        Ap ap = this.i.findByMac(string);
        if (ap == null) {
            return false;
        }
        if (ap.getMeshConf() == null || CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs()) || !ap.getMeshConf().getChildApMacs().contains(string2)) {
            return false;
        }
        int n2 = this.E.getHop(string2);
        if (!com.tp_link.eap.util.l.a((long)MeshFailoverRecord.getIsolated((String)string2), (long)(com.tp_link.eap.c.a.d + 30000 * n2))) {
            ae.debug("childMac {} parent {} is linked possibly ", (Object)string2, (Object)string);
            return true;
        }
        if (ap.getStatus() == 0 && com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)450000L)) {
            ae.debug("childMac {} parent {} is always disconenected", (Object)string2, (Object)string);
            return false;
        }
        if (ap.getWirelessLinked().booleanValue() && ap.getStatus() == 4 && ((statMeshInfo = this.E.getStatMeshByMac(string)) == null || statMeshInfo.getUplinkInfo() == null || com.tp_link.eap.util.l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)600000L))) {
            ae.debug("childMac {} parent {} is always isolated", (Object)string2, (Object)string);
            return false;
        }
        ae.debug("" + OperationRecord.controllerStartTime);
        return ap.getStatus() != 1 || !com.tp_link.eap.util.l.a((long)OperationRecord.controllerStartTime, (long)300000L) || (statMeshInfo = this.E.getStatMeshByMac(string2)) != null && statMeshInfo.getUplinkInfo() != null && !com.tp_link.eap.util.l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApToIsolated(String mac) {
        Object object;
        boolean bl = false;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)mac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(mac);
            if (ap != null && ap.getStatus() != 2) {
                if (ap.getStatus() != 4 || MeshFailoverRecord.getIsolated((String)mac) == 0L) {
                    MeshFailoverRecord.addIsolated((String)mac);
                }
                if (ap.getStatus() == 1 && com.tp_link.eap.util.l.a((long)ap.getLastSeen(), (long)60000L)) {
                    bl = true;
                }
                ap.setStatus(Integer.valueOf(4));
                ap.setWirelessLinked(Boolean.valueOf(true));
                ap.setStatusWireless(Integer.valueOf(1));
                ap.setLastSeen(System.currentTimeMillis());
                this.refreshAp(ap);
                ae.debug("Set {} to isolated", (Object)mac);
            }
        }
        if (bl) {
            CacheTask.a.a(mac);
            this.clearStatistics(mac);
            if (com.tp_link.eap.h.d.c.d((String)mac)) {
                com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, mac);
            }
        }
    }

    private void a(Map<Integer, Set<String>> map, byte[] byArray) {
        if (map == null) {
            return;
        }
        ae.debug(map.toString());
        Map<Integer, Set<String>> map2 = map;
        this.ad.execute(new n(this, map2, byArray));
    }

    @Override
    public void clearWirelessInfo(String apMac, MeshInfo meshInfo, boolean wirelessLinked) {
        Ap ap = this.i.findByMac(apMac);
        if (ap != null && !ap.getWirelessLinked().booleanValue() && meshInfo.getStatus() == 0 && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            ae.debug("clearWirelessInfo");
            this.disconnectChildAp(apMac, true);
            this.b(apMac);
        }
    }

    private void b(String string) {
        Mesh mesh = new Mesh();
        MeshSetting meshSetting = this.A.getMeshSettingByMac(string);
        if (meshSetting != null) {
            mesh = this.z.a(meshSetting);
        }
        this.z.a(mesh, string);
        this.w.refreshRecord(string, "mesh", mesh);
    }

    @Override
    public void forgetApsByHop(List<String> macList) {
        Map<Integer, Set<String>> map = this.E.getHopMap(macList);
        if (map != null) {
            ae.debug("all: {}", (Object)map.toString());
            for (int i2 = 3; i2 >= 0; --i2) {
                Set<String> set = map.get(i2);
                if (CollectionUtils.isEmpty(set)) continue;
                ae.debug("now: {}", (Object)set.toString());
                com.tp_link.eap.util.o.b.a((Integer)0, set);
                for (String string : set) {
                    this.forgetAp(this.getApByMac(string).getId());
                }
                if (i2 > 0) {
                    for (int i3 = 0; com.tp_link.eap.util.o.b.c((Integer)0, set) != 2 && i3 < com.tp_link.eap.c.a.f; ++i3) {
                        try {
                            Thread.sleep(com.tp_link.eap.c.a.e);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            ae.warn(interruptedException.toString(), (Throwable)interruptedException);
                        }
                    }
                }
                com.tp_link.eap.util.o.b.b((Integer)0, set);
            }
        }
    }

    @Override
    public OperationResponse getGridAps(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid<Ap> grid = this.a(queryData);
        List list = grid.getData();
        ArrayList<ApInfo> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<ApInfo>();
            for (Ap ap : list) {
                ApInfo apInfo = ApInfo.convertFromAp(ap);
                arrayList.add(apInfo);
            }
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, grid);
    }

    private Grid<Ap> a(QueryData queryData) {
        String string;
        int n2;
        boolean bl = false;
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
            queryData.setSortOrder("asc");
        } else if (queryData.getSortName().equals(Q)) {
            queryData.setSortName("status,realtimeStatus,wirelessLinked,managedMark");
            bl = true;
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "mac", "ip"});
        String string2 = (String)queryData.getFilters().get(Q);
        if (string2 != null && !string2.equalsIgnoreCase("all")) {
            n2 = com.tp_link.eap.util.e.a((String)string2);
            grid.initFilters(Q, (Object)n2, QueryFilter.FilterType.eq);
        }
        if (queryData.getFilters() != null && queryData.getFilters().get("managedMark") != null) {
            n2 = (Integer)queryData.getFilters().get("managedMark");
            grid.initFilters("managedMark", (Object)n2, QueryFilter.FilterType.eq);
        }
        if (queryData.getFilters() != null && queryData.getFilters().get("wirelessLinked") != null) {
            Boolean bl2 = (Boolean)queryData.getFilters().get("wirelessLinked");
            grid.initFilters("wirelessLinked", (Object)bl2, QueryFilter.FilterType.eq);
        }
        boolean bl3 = false;
        Map map = queryData.getFilters();
        Object v = map.get("apType");
        if (v != null && (string = (String)v).equals("mesh")) {
            bl3 = true;
        }
        long l2 = 0L;
        List<Object> list = new ArrayList();
        if (!bl3) {
            l2 = this.count(grid);
            grid.setTotalRows(l2);
            list = this.getList(grid);
        } else {
            String string3 = queryData.getSortName();
            if (!com.tp_link.eap.util.a.e.a((String)string3) && !string3.contains("mac")) {
                queryData.setSortName(string3 + ",mac");
            }
            if (string2.equalsIgnoreCase("connected") || string2.equalsIgnoreCase("all")) {
                l2 = this.countMeshAp(grid.getFilters(), grid.getSearchFilters());
                if (l2 > 0L) {
                    this.I.updateMeshNetwowrk();
                    l2 = this.I.count(grid.getFilters(), grid.getSearchFilters());
                }
                grid.setTotalRows(l2);
                if (l2 > 0L) {
                    list = this.I.getMeshList(grid.getQueryPage(), grid.getQuerySort(), grid.getFilters(), grid.getSearchFilters(), com.tp_link.eap.d.b.a());
                }
            } else {
                l2 = 0L;
                grid.setTotalRows(l2);
            }
            grid.getQueryData().setSortName(string3);
        }
        grid.setData(list);
        if (bl) {
            grid.getQueryData().setSortName(Q);
        }
        return grid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse existApNeedToUpgrade(ControlType controlType, JSONObject reqObj) {
        boolean bl = false;
        boolean bl2 = false;
        Object object = com.tp_link.eap.b.b.a.a();
        synchronized (object) {
            List<Ap> list;
            UpgradeWarning upgradeWarning = this.F.getUpgradeWarning();
            if (upgradeWarning == null) {
                bl2 = true;
                upgradeWarning = new UpgradeWarning();
            }
            if (!CollectionUtils.isEmpty(list = this.getApNeedToUpgrade())) {
                for (Ap ap : list) {
                    if (ap.getRealtimeStatus() == RealtimeStatus.c.a()) continue;
                    bl = true;
                    break;
                }
            }
            ae.debug("exist uncompatilbe ap : {}", (Object)bl);
            if (bl2) {
                ae.debug("warning not exist, create new one.");
                upgradeWarning.setShowUpgradeIcon(bl);
                upgradeWarning.setShowUpgradeWarning(bl);
                this.F.refreshUpgradeWarning(upgradeWarning);
            } else if (bl) {
                if (!upgradeWarning.isShowUpgradeIcon() || !upgradeWarning.isShowUpgradeWarning()) {
                    upgradeWarning.setShowUpgradeIcon(true);
                    upgradeWarning.setShowUpgradeWarning(true);
                    this.F.refreshUpgradeWarning(upgradeWarning);
                }
            } else {
                ae.debug("not exist uncompatible ap {}", (Object)upgradeWarning);
                if (upgradeWarning.isShowUpgradeWarning() || upgradeWarning.isShowUpgradeIcon()) {
                    upgradeWarning.setShowUpgradeIcon(false);
                    upgradeWarning.setShowUpgradeWarning(false);
                    this.F.refreshUpgradeWarning(upgradeWarning);
                }
            }
            return new OperationResponse(ResErrorCode.a, (Object)upgradeWarning);
        }
    }

    @Override
    public OperationResponse getBatchAdoptState(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("running", com.tp_link.eap.monitor.monitor.realtime.a.a());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse adoptFactoryAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getAp(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (ap.getStatus() != 2) {
            return new OperationResponse(ResErrorCode.dT);
        }
        return this.adoptAp(ap.getMac(), "admin", "admin", null);
    }

    @Override
    public OperationResponse adoptAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        String string2 = jSONObject.optString("userName");
        String string3 = jSONObject.optString("password");
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2) || com.tp_link.eap.util.a.e.a((String)string3)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getAp(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (ap.getStatus() != 2) {
            return new OperationResponse(ResErrorCode.dT);
        }
        return this.adoptAp(ap.getMac(), string2, string3, null);
    }

    @Override
    public OperationResponse rebootAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.reboot(string);
    }

    @Override
    public OperationResponse checkBatchAdoptPermission(ControlType controlType, JSONObject reqObj) {
        List<Ap> list = this.getPendingAps();
        if (CollectionUtils.isEmpty(list)) {
            return new OperationResponse(ResErrorCode.V);
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Boolean bl = Boolean.TRUE;
        for (Ap ap : list) {
            if (ap.getStatus() != 2 || ap.getAdoptStatus() != 2) continue;
            bl = Boolean.FALSE;
        }
        hashMap.put("allow", bl);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse batchAdoptAps(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("userName");
        String string2 = jSONObject.optString("password");
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.batchAdopt(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OperationResponse forgetAll(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Object object = jSONObject.opt(Q);
        if (object == null || !(object instanceof Integer)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = (Integer)object;
        if (n2 == null || n2 < 0 || n2 > 3) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (OperationRecord.isFortgetDoing((String)string)) {
            return new OperationResponse(ResErrorCode.dU);
        }
        OperationRecord.refresh((String)string);
        List<Object> list = new ArrayList();
        switch (n2) {
            case 1: {
                list = this.getSiteConnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 2: {
                list = this.getSiteDisconnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 3: {
                list = this.getSiteIsolatedAps(com.tp_link.eap.d.b.a());
                break;
            }
            default: {
                list = this.getSiteAdoptedAps(com.tp_link.eap.d.b.a());
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Ap ap : list) {
                arrayList.add(ap.getMac());
            }
            Map<Integer, List<MeshRelation>> map = this.E.getApMapByHop(arrayList);
            if (!CollectionUtils.isEmpty((Map)map)) {
                void var11_13;
                int i2 = 3;
                while (var11_13 >= 0) {
                    List list2 = (List)map.get((int)var11_13);
                    if (!CollectionUtils.isEmpty((Collection)list2)) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (MeshRelation interruptedException : list2) {
                            if (interruptedException.getStatus() != 1) continue;
                            hashSet.add(interruptedException.getMac());
                        }
                        ae.debug(((Object)hashSet).toString());
                        com.tp_link.eap.util.o.b.a((Integer)0, hashSet);
                        for (MeshRelation interruptedException : list2) {
                            ae.debug(interruptedException.getMac());
                            if (com.tp_link.eap.monitor.monitor.realtime.c.d(interruptedException.getMac())) {
                                bl = true;
                                continue;
                            }
                            Ap ap = this.getApDetail(interruptedException.getMac());
                            if (ap == null) continue;
                            this.forgetAp(ap.getId());
                        }
                        if (var11_13 > 0) {
                            for (int i3 = 0; com.tp_link.eap.util.o.b.c((Integer)0, hashSet) != 2 && i3 < com.tp_link.eap.c.a.f; ++i3) {
                                try {
                                    Thread.sleep(com.tp_link.eap.c.a.e);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    ae.warn(interruptedException.toString(), (Throwable)interruptedException);
                                }
                            }
                        }
                        com.tp_link.eap.util.o.b.b((Integer)0, hashSet);
                    }
                    --var11_13;
                }
            }
            if (bl) {
                OperationRecord.removeForget((String)string);
                return new OperationResponse(ResErrorCode.W);
            }
        } else {
            OperationRecord.removeForget((String)string);
            return new OperationResponse(ResErrorCode.X);
        }
        if (n2 == 0 || n2 == 1) {
            this.forgetWirelessPendingSite(string);
        }
        OperationRecord.removeForget((String)string);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse setApName(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apName");
        String string2 = jSONObject.optString("apId");
        if (!com.tp_link.eap.util.p.c.a((String)string, (int)1, (int)64)) {
            return new OperationResponse(ResErrorCode.Y);
        }
        return this.setName(string2, string);
    }

    @Override
    public OperationResponse setApRadio(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Radio radio = (Radio)JSONObject.toBean((JSONObject)jSONObject, Radio.class);
        if (radio == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (radio.isRadioEnable()) {
            int n2 = radio.getRadioId();
            int n3 = Integer.parseInt(radio.getRadioMode());
            Ap ap = this.getAp(radio.getApId());
            if (ap == null) {
                return new OperationResponse(ResErrorCode.Z);
            }
            String string = ap.getWlanGroupId2G();
            String string2 = ap.getWlanGroupId5G();
            OperationResponse operationResponse = this.v.checkApRadioMode(n3, n2, n2 == 0 ? string : string2);
            if (!operationResponse.success()) {
                return operationResponse;
            }
        }
        return this.setRadio(radio, false);
    }

    @Override
    public OperationResponse setApIpSetting(ControlType controlType, JSONObject reqObj) {
        Ap ap;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        IpSetting ipSetting = (IpSetting)JSONObject.toBean((JSONObject)jSONObject, IpSetting.class);
        if (ipSetting == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (ipSetting.getMode().equals("dhcp")) {
            if (ipSetting.isFallback()) {
                if (!com.tp_link.eap.util.p.c.a((String)ipSetting.getFallbackIp())) {
                    return new OperationResponse(ResErrorCode.aa);
                }
                if (!com.tp_link.eap.util.p.c.c((String)ipSetting.getFallbackMask())) {
                    return new OperationResponse(ResErrorCode.ab);
                }
                if (!com.tp_link.eap.util.a.e.a((String)ipSetting.getConfigGate()) && !com.tp_link.eap.util.p.c.a((String)ipSetting.getFallbackGate())) {
                    return new OperationResponse(ResErrorCode.ac);
                }
                ipSetting.setPreferredDNS("");
                ipSetting.setAlternateDNS("");
            }
        } else {
            if (!com.tp_link.eap.util.p.c.a((String)ipSetting.getConfigIp())) {
                return new OperationResponse(ResErrorCode.ad);
            }
            if (!com.tp_link.eap.util.p.c.c((String)ipSetting.getFallbackMask())) {
                return new OperationResponse(ResErrorCode.ae);
            }
            if (!com.tp_link.eap.util.a.e.a((String)ipSetting.getConfigGate())) {
                if (!com.tp_link.eap.util.p.c.a((String)ipSetting.getConfigGate())) {
                    return new OperationResponse(ResErrorCode.ac);
                }
            } else {
                return new OperationResponse(ResErrorCode.ac);
            }
            if (!com.tp_link.eap.util.a.e.a((String)ipSetting.getPreferredDNS())) {
                if (!com.tp_link.eap.util.p.c.a((String)ipSetting.getPreferredDNS())) {
                    return new OperationResponse(ResErrorCode.af);
                }
            } else {
                ipSetting.setPreferredDNS("");
            }
            if (!com.tp_link.eap.util.a.e.a((String)ipSetting.getAlternateDNS())) {
                if (!com.tp_link.eap.util.p.c.a((String)ipSetting.getAlternateDNS())) {
                    return new OperationResponse(ResErrorCode.af);
                }
            } else {
                ipSetting.setAlternateDNS("");
            }
            if (com.tp_link.eap.util.a.e.a((String)ipSetting.getPreferredDNS()) && !com.tp_link.eap.util.a.e.a((String)ipSetting.getAlternateDNS())) {
                ipSetting.setPreferredDNS(ipSetting.getAlternateDNS());
                ipSetting.setAlternateDNS("");
            }
        }
        if ((ap = this.getAp(ipSetting.getApId())) == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        IpSetting ipSetting2 = ap.getIpSetting();
        if (ipSetting2.toString().equals(ipSetting.toString())) {
            return com.tp_link.eap.util.e.bd;
        }
        boolean bl = false;
        bl = this.checkIpChange(ipSetting2, ipSetting);
        return this.setIpSetting(ipSetting, false, bl);
    }

    @Override
    public OperationResponse setLinkAggregation(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        TrunkSetting trunkSetting = (TrunkSetting)JSONObject.toBean((JSONObject)jSONObject, TrunkSetting.class);
        return this.setTrunkSetting(trunkSetting, false);
    }

    @Override
    public OperationResponse setApWlanGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        String string2 = jSONObject.optString("wlanId");
        Integer n2 = (Integer)jSONObject.opt("radioId");
        if (string == null || string2 == null || n2 == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.setWlanGroup(string, n2, string2, true);
    }

    @Override
    public OperationResponse setApLoadBalance(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        LoadBalanceWithRssi loadBalanceWithRssi = (LoadBalanceWithRssi)JSONObject.toBean((JSONObject)jSONObject, LoadBalanceWithRssi.class);
        if (loadBalanceWithRssi == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (loadBalanceWithRssi.isLbEnable() && !com.tp_link.eap.util.p.c.a((int)loadBalanceWithRssi.getMaxClients(), (int)1, (int)99)) {
            return new OperationResponse(ResErrorCode.ap);
        }
        if (loadBalanceWithRssi.isRssiEnable() && !com.tp_link.eap.util.p.c.a((int)loadBalanceWithRssi.getThreshold(), (int)-95, (int)0)) {
            return new OperationResponse(ResErrorCode.aq);
        }
        LoadBalance loadBalance = new LoadBalance();
        loadBalance.setApId(loadBalanceWithRssi.getApId());
        loadBalance.setEnable(loadBalanceWithRssi.isLbEnable());
        loadBalance.setMaxClients(Integer.valueOf(loadBalanceWithRssi.getMaxClients()));
        loadBalance.setRadioId(loadBalanceWithRssi.getRadioId());
        OperationResponse operationResponse = this.setLoadBalance(loadBalance, false);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        RssiThreshold rssiThreshold = new RssiThreshold(loadBalanceWithRssi.isRssiEnable(), loadBalanceWithRssi.getThreshold());
        rssiThreshold.setApId(loadBalanceWithRssi.getApId());
        rssiThreshold.setRadioId(loadBalanceWithRssi.getRadioId());
        return this.setRssi(rssiThreshold, false);
    }

    @Override
    public OperationResponse setApSsidOverride(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        SsidOverride ssidOverride = (SsidOverride)JSONObject.toBean((JSONObject)jSONObject, SsidOverride.class);
        if (ssidOverride == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ssidOverride.setSsid(ssidOverride.getSsid().trim());
        if (ssidOverride.isEnable()) {
            if (ssidOverride.isVlanEnable() && !com.tp_link.eap.util.p.c.a((int)ssidOverride.getVlanId(), (int)0, (int)4094)) {
                return new OperationResponse(ResErrorCode.ar);
            }
            if (!com.tp_link.eap.util.l.j((String)ssidOverride.getSsid())) {
                return new OperationResponse(ResErrorCode.as);
            }
            if (!com.tp_link.eap.util.a.e.a((String)ssidOverride.getPsk()) && !com.tp_link.eap.util.p.c.e((String)ssidOverride.getPsk())) {
                ae.warn("PSK should be 8-63 ASCII characters or 8-64 Hexadecimal characters");
                return new OperationResponse(ResErrorCode.at);
            }
        }
        return this.setSsidOverride(ssidOverride, false);
    }

    @Override
    public OperationResponse setApRogueStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        Object object = jSONObject.opt("rogueStatus");
        if (!(object instanceof Boolean)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Boolean bl = (Boolean)object;
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.setApRogueStatus(string, bl, false);
    }

    @Override
    public OperationResponse forgetAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.forgetAp(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse saveSchedulerAssociationAp(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        SchedulerAssociationApInfo schedulerAssociationApInfo = (SchedulerAssociationApInfo)JSONObject.toBean((JSONObject)jSONObject, SchedulerAssociationApInfo.class);
        if (schedulerAssociationApInfo == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ap ap = this.getAp(schedulerAssociationApInfo.getId());
        if (ap == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = ap.getMac();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            ap = this.getApDetail(string);
            ap.setSchedulerId(schedulerAssociationApInfo.getProfileId());
            ap.setSchedulerAction(schedulerAssociationApInfo.getSchedulerAction());
            return this.saveAssociationAp(ap, false);
        }
    }

    @Override
    public OperationResponse setApLocation(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        String string2 = jSONObject.optString("mapId", null);
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (!jSONObject.containsKey((Object)"x") || !jSONObject.containsKey((Object)"y")) {
            return new OperationResponse(ResErrorCode.d);
        }
        Double d2 = jSONObject.optDouble("x", 0.0);
        Double d3 = jSONObject.optDouble("y", 0.0);
        Ap ap = this.getApDetail(string);
        if (ap == null) {
            return new OperationResponse(ResErrorCode.Z);
        }
        Location location = ap.getLocation();
        location.setLocated(true);
        location.setMapId(string2);
        location.setPosX(d2.doubleValue());
        location.setPosY(d3.doubleValue());
        if (this.locate(string, location)) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public OperationResponse unlocateAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (this.unLocate(string)) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public OperationResponse lockApPosition(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (this.lock(string, true)) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public OperationResponse unlockApPosition(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (this.lock(string, false)) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public OperationResponse getSingleUpgradeResult(ControlType controlType, JSONObject reqObj) {
        String string;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject != null && !StringUtils.isBlank((String)(string = jSONObject.optString("mac")))) {
            return new OperationResponse(ResErrorCode.a, (Object)SingleUpgradeResult.d(string));
        }
        return new OperationResponse(ResErrorCode.a, (Object)SingleUpgradeResult.d());
    }

    @Override
    public OperationResponse getSupportModel(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("data", this.getSupportModel(string));
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getUpgradingModel(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        List<String> list = this.getSupportModel(string);
        if (!CollectionUtils.isEmpty(list)) {
            for (String string2 : list) {
                if (!com.tp_link.eap.monitor.monitor.realtime.d.b(string, string2)) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("data", string2);
                return new OperationResponse(ResErrorCode.a, hashMap);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getModelAPCount(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("eapModel", null);
        ae.debug("web countModelEaps - eapModel = " + string);
        String string2 = string;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (string2 == null || string2.equals("")) {
            hashMap.put("data", 0);
            return new OperationResponse(ResErrorCode.a, hashMap);
        }
        ae.debug("db getConnectedApsByModelModelVersion eapModelModelVersion = " + string2);
        List<Ap> list = this.getConnectedApsByModelModelVersion(string2);
        ae.debug("db modelAps.size = " + list.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Ap ap : list) {
            if (ap.getRealtimeStatus() != RealtimeStatus.a.a()) continue;
            arrayList.add(ap.getMac());
        }
        hashMap.put("data", arrayList.size());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getUpgradeResult(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        OperationResult operationResult = com.tp_link.eap.monitor.monitor.upgrade.a.a(string);
        if (operationResult == null) {
            return new OperationResponse(ResErrorCode.a, ResErrorCode.a.b(), null);
        }
        if (operationResult.isSuccess()) {
            return new OperationResponse(ResErrorCode.a, operationResult.getMessage(), operationResult.getValue());
        }
        return new OperationResponse(ResErrorCode.du, (Object)operationResult.getMessage());
    }

    @Override
    public OperationResponse getUpgradingInfo(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        OperationResult operationResult = com.tp_link.eap.monitor.monitor.upgrade.a.b(string);
        if (operationResult == null) {
            return com.tp_link.eap.util.e.bd;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("data", operationResult.getValue());
        return new OperationResponse(ResErrorCode.a, operationResult.getMessage(), hashMap);
    }

    @Override
    public OperationResponse upgrade(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId", null);
        if (string == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        byte[] byArray = com.tp_link.eap.util.g.a.a((HttpServletRequest)request);
        OperationResponse operationResponse = com.tp_link.eap.monitor.monitor.upgrade.a.a.a(byArray);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getAp(string).getMac());
        return this.upgrade(arrayList, byArray, null, null);
    }

    @Override
    public OperationResponse upgrade(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId", null);
        if (string == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = com.tp_link.eap.monitor.monitor.upgrade.a.a.a(fileContent);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getAp(string).getMac());
        return this.upgrade(arrayList, fileContent, null, null);
    }

    @Override
    public OperationResponse batchUpgrade(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        byte[] byArray;
        String string;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = string = jSONObject.optString("eapModel");
        ae.debug("fw eapModel=" + string);
        if (string2 == null || string2.equals("")) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string3 = com.tp_link.eap.d.b.a();
        String string4 = "upgradeType";
        int n2 = jSONObject.optInt(string4);
        if (n2 == 0) {
            response.setCharacterEncoding("UTF-8");
            byArray = com.tp_link.eap.util.g.a.a((HttpServletRequest)request);
        } else {
            byArray = this.g(string2);
        }
        return this.a(controlType, string3, string2, byArray, n2);
    }

    @Override
    public OperationResponse batchUpgrade(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        String string;
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = string = jSONObject.optString("eapModel");
        ae.debug("fw eapModel=" + string);
        if (string2 == null || string2.equals("")) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string3 = com.tp_link.eap.d.b.a();
        String string4 = "upgradeType";
        int n2 = jSONObject.optInt(string4);
        if (n2 == 1) {
            fileContent = this.g(string2);
        }
        return this.a(controlType, string3, string2, fileContent, n2);
    }

    @Override
    public OperationResponse setLanPortSettings(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apId", null);
        JSONArray jSONArray = jSONObject.optJSONArray("lanPortSettings");
        if (com.tp_link.eap.util.a.e.a((String)string) || jSONArray == null) {
            ae.warn("Invalid input");
            return com.tp_link.eap.util.e.aZ;
        }
        List list = JSONArray.toList((JSONArray)jSONArray, (Object)new LanPortSetting(), (JsonConfig)new JsonConfig());
        ae.debug("lanPortSettings: {}", (Object)jSONArray.toString());
        return this.setLanPortSettings(string, list);
    }

    @Override
    public OperationResponse checkApBandWidthSupport(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        Ap ap = this.getApDetail(string);
        boolean bl = ap == null ? false : com.tp_link.eap.util.j.b.d((String)this.b(ap));
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("support80", bl);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getEAPFwInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        List<String> list = this.getSupportModel(string);
        long l2 = list.size();
        List<ModelFw> list2 = this.m.getByCategory(ModelFw.DeviceCategory.EAP.getCategory());
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName(P);
            queryData.setSortOrder("asc");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[0]);
        grid.initFilters("category", (Object)ModelFw.DeviceCategory.EAP.getCategory(), QueryFilter.FilterType.eq);
        grid.setTotalRows(l2);
        ArrayList<ModelFw> arrayList = new ArrayList<ModelFw>();
        for (ModelFw object2 : list2) {
            if (!list.contains(object2.getModelModelVersion())) continue;
            arrayList.add(object2);
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList arrayList2 = new ArrayList();
        Map<String, Set<String>> map = this.i(string);
        for (ModelFw modelFw : arrayList) {
            ModelFwEntry modelFwEntry = new ModelFwEntry();
            modelFwEntry.setModelModelVersion(modelFw.getModelModelVersion());
            modelFwEntry.setApCount(this.getUpgradeableAps(string, modelFw.getModelModelVersion()).size());
            Set<String> set = map.get(modelFw.getModelModelVersion());
            ArrayList<String> arrayList3 = set != null ? new ArrayList<String>(set) : new ArrayList();
            String string2 = modelFw.getLastFwVer();
            modelFwEntry.setCurFws(arrayList3);
            if (arrayList3.size() == 1 && com.tp_link.eap.monitor.c.a.a(com.tp_link.eap.monitor.c.a.b((String)arrayList3.get(0)), com.tp_link.eap.monitor.c.a.b(string2)) >= 0) {
                string2 = null;
            }
            modelFwEntry.setLastFw(string2);
            modelFwEntry.setFwReleaseLog(StringUtils.isBlank((String)string2) ? null : modelFw.getFwReleaseLog());
            if (StringUtils.isBlank((String)modelFw.getEncryptedHwId()) || StringUtils.isBlank((String)modelFw.getEncryptedOemId()) || arrayList3.size() == 0) {
                modelFwEntry.setSupportOnlineUpgrade(false);
            } else {
                modelFwEntry.setSupportOnlineUpgrade(true);
            }
            arrayList2.add(modelFwEntry);
        }
        grid.setData((List)arrayList2);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse onlineCheckEAPLastFw(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        return new OperationResponse(this.onlineCheckEAPLastFw(true, string));
    }

    @Override
    public OperationResponse downloadEAPFw(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.has(P)) {
            ae.warn("Invalid request, parameter '' is missing.", (Object)P);
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString(P);
        if (com.tp_link.eap.util.l.b() && !this.n.checkCloudAccessEnable()) {
            return new OperationResponse(ResErrorCode.et);
        }
        b b2 = new b(this, string);
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        return new OperationResponse(this.a(string, b2, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getEAPFwDownloadProgress(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.has(P)) {
            ae.warn("Invalid request, parameter '' is missing.", (Object)P);
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString(P);
        Object object = this.Z;
        synchronized (object) {
            q q2 = this.aa.get(string);
            if (q2 == null) {
                ae.warn("Download thread of firmware of EAP model({}) isn't started.", (Object)string);
                return new OperationResponse(ResErrorCode.b);
            }
            Object object2 = q2.a();
            AtomicInteger atomicInteger = q2.b();
            if (object2 == null && atomicInteger.get() == 100) {
                ae.info("Firmware has existed before controller started.");
            } else if (object2 != null && object2.isDone() && atomicInteger.get() < 100) {
                ae.warn("Failed to download complete firmware of  EAP model({}).", (Object)string);
                return new OperationResponse(q2.d());
            }
            object2 = "progress";
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(object2, (Object)atomicInteger.get());
            return new OperationResponse(ResErrorCode.a, ResErrorCode.a.b(), (Object)jSONObject2);
        }
    }

    @Override
    public ResErrorCode onlineCheckEAPLastFw(boolean isManual, String site) {
        ResErrorCode resErrorCode = ResErrorCode.a;
        ResErrorCode resErrorCode2 = this.g();
        if (!resErrorCode2.equals((Object)ResErrorCode.a)) {
            return resErrorCode2;
        }
        Map<String, String> map = this.h(site);
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String string;
            String string2 = entry.getKey();
            ResErrorCode resErrorCode3 = this.a(isManual, string2, string = entry.getValue());
            if (resErrorCode3.a() == ResErrorCode.a.a()) continue;
            ae.info("Failed to check last firmware for modelModelVersion({}), currentFwVer({}).", (Object)string2, (Object)string);
            if (isManual) {
                return resErrorCode3;
            }
            if (!resErrorCode.equals((Object)ResErrorCode.a)) continue;
            resErrorCode = resErrorCode3;
        }
        return resErrorCode;
    }

    @Override
    public OperationResponse onlineCheckSingleAPLastFw(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        if (StringUtils.isBlank((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            ae.warn("Can't find a matched ap by mac({}).", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        ResErrorCode resErrorCode = this.g();
        if (!resErrorCode.equals((Object)ResErrorCode.a)) {
            return new OperationResponse(resErrorCode);
        }
        if (com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion())) {
            ae.warn("Firmware version({}) of model({}) of ap({}) is in incompatible firmware versions, so shouldn't check new firmware version.", new Object[]{ap.getVersion(), ap.getModelModelVersion(), ap.getMac()});
            return new OperationResponse(ResErrorCode.dq);
        }
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        ResErrorCode resErrorCode2 = this.a(true, ap.getModelModelVersion(), ap.getVersion());
        return new OperationResponse(resErrorCode2);
    }

    @Override
    public OperationResponse getAPFirmwareInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        if (StringUtils.isBlank((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            ae.warn("Can't find a matched ap by mac({}).", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put((Object)S, (Object)ap.getVersion());
        ModelFw modelFw = this.m.getModelInfo(ap.getModelModelVersion());
        if (!com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion()) && modelFw != null && com.tp_link.eap.monitor.c.a.a(modelFw.getLastFwVer(), ap.getVersion()) > 0) {
            jSONObject2.put((Object)U, (Object)modelFw.getLastFwVer());
            jSONObject2.put((Object)V, (Object)modelFw.getFwReleaseLog());
        }
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject2);
    }

    @Override
    public OperationResponse getAPUpgradeFirmwareInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        if (StringUtils.isBlank((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            ae.warn("Can't find a matched ap by mac({}).", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        JSONObject jSONObject2 = new JSONObject();
        boolean bl = false;
        if (!com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion())) {
            ResErrorCode resErrorCode = this.g();
            if (!resErrorCode.equals((Object)ResErrorCode.a)) {
                return new OperationResponse(resErrorCode);
            }
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            ResErrorCode resErrorCode2 = this.a(true, ap.getModelModelVersion(), ap.getVersion());
            if (!resErrorCode2.equals((Object)ResErrorCode.a)) {
                return new OperationResponse(resErrorCode2);
            }
            ModelFw modelFw = this.m.getModelInfo(ap.getModelModelVersion());
            if (modelFw != null && com.tp_link.eap.monitor.c.a.a(modelFw.getLastFwVer(), ap.getVersion()) > 0) {
                jSONObject2.put((Object)U, (Object)modelFw.getLastFwVer());
                jSONObject2.put((Object)V, (Object)modelFw.getFwReleaseLog());
                bl = true;
            }
        } else {
            ae.warn("Firmware version({}) of model({}) of ap({}) is in incompatible firmware versions, so shouldn't check new firmware version.", new Object[]{ap.getVersion(), ap.getModelModelVersion(), ap.getMac()});
        }
        jSONObject2.put((Object)S, (Object)ap.getVersion());
        jSONObject2.put((Object)T, (Object)bl);
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject2);
    }

    @Override
    public OperationResponse onlineUpgradeAP(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        ResErrorCode resErrorCode = this.g();
        if (!resErrorCode.equals((Object)ResErrorCode.a)) {
            return new OperationResponse(resErrorCode);
        }
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        return new OperationResponse(this.f(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse cancelOnlineUpgradeAP(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        if (StringUtils.isBlank((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Object object = this.Z;
        synchronized (object) {
            Thread thread;
            o o2 = this.ab.get(string);
            if (o2 != null) {
                thread = o2.e();
                if (thread == null || !thread.isAlive()) {
                    ae.warn("There is no matched download thread running.");
                    return com.tp_link.eap.util.e.aY;
                }
            } else {
                ae.warn("Failed to get matched upgrade information.");
                return com.tp_link.eap.util.e.aY;
            }
            thread.interrupt();
            this.ab.remove(string);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getApOnlineUpgradeInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac");
        if (StringUtils.isBlank((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            ae.warn("Can't find a matched ap by mac({}).", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        Object object = this.Z;
        synchronized (object) {
            o o2 = this.ab.get(string);
            if (o2 != null) {
                JSONObject jSONObject2 = new JSONObject();
                ResErrorCode resErrorCode = o2.b();
                String string2 = o2.c();
                if (!resErrorCode.equals((Object)ResErrorCode.a)) {
                    this.ab.remove(string);
                    return new OperationResponse(resErrorCode, StringUtils.isBlank((String)string2) ? resErrorCode.b() : string2, null);
                }
                p p2 = o2.d();
                jSONObject2.put((Object)Q, (Object)p2.a());
                if (p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.b)) {
                    q q2 = this.aa.get(ap.getModelModelVersion());
                    if (q2 == null) {
                        ae.warn("Failed to get matched model({}) upgrade information.", (Object)ap.getModelModelVersion());
                        this.ab.remove(string);
                        return com.tp_link.eap.util.e.aY;
                    }
                    jSONObject2.put((Object)R, (Object)((int)((double)q2.b().get() * 0.3)));
                } else {
                    jSONObject2.put((Object)R, (Object)o2.f().get());
                }
                if (p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.a) || p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.e)) {
                    this.ab.remove(string);
                }
                return new OperationResponse(ResErrorCode.a, (Object)jSONObject2);
            }
            ae.debug("Failed to get matched ap upgrade information.");
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put((Object)Q, (Object)com.tp_link.eap.monitor.monitor.service.impl.p.a.a());
            jSONObject3.put((Object)R, (Object)0);
            return new OperationResponse(ResErrorCode.a, (Object)jSONObject3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse onlineBatchUpgrade(ControlType controlType, JSONObject reqObj) {
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        ResErrorCode resErrorCode = this.g();
        if (!resErrorCode.equals((Object)ResErrorCode.a)) {
            return new OperationResponse(resErrorCode);
        }
        String string = com.tp_link.eap.d.b.a();
        Object object = this.Z;
        synchronized (object) {
            if (this.ac.contains(string)) {
                ae.warn("Online upgrading all APs is already running, can't be executed util last operation is finished.");
                return new OperationResponse(ResErrorCode.dt);
            }
            this.ac.add(string);
            this.ad.execute(() -> {
                Object object;
                try {
                    object = this.onlineCheckEAPLastFw(true, string);
                    if (!object.equals((Object)ResErrorCode.a)) {
                        ae.warn("Failed to check last firmware version for all modelModelVersion.");
                    }
                    TreeMap treeMap = new TreeMap(Collections.reverseOrder());
                    treeMap.putAll(this.E.getApMapByHop(string));
                    Set set = treeMap.entrySet();
                    for (Map.Entry entry : set) {
                        ae.info("Begin to online upgrade hop({})'s aps.", entry.getKey());
                        List list = (List)entry.getValue();
                        this.g(list);
                        ae.info("Finish online upgrading of hop({})'s aps.", entry.getKey());
                    }
                }
                finally {
                    object = this.Z;
                    synchronized (object) {
                        this.ac.remove(string);
                    }
                }
            });
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getOnlineBatchUpgradeInfo(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        JSONObject jSONObject = new JSONObject();
        Object object = this.Z;
        synchronized (object) {
            jSONObject.put((Object)Q, (Object)(this.ac.contains(string) ? 1 : 0));
        }
        boolean bl = false;
        List<Ap> list = this.getSiteConnectedAps(string);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                if (!this.c(ap)) continue;
                bl = true;
                break;
            }
        }
        jSONObject.put((Object)T, (Object)bl);
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public boolean isAncestorUpgrading(Ap ap) {
        boolean bl = false;
        while (ap != null && ap.getWirelessLinked().booleanValue() && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            Ap ap2 = this.getApByMac(ap.getMeshConf().getParentApMac());
            if (ap2.getRealtimeStatus() == RealtimeStatus.c.ordinal()) {
                bl = true;
                break;
            }
            ap = ap2;
        }
        return bl;
    }

    @Override
    public boolean isOffspringUpgrading(Ap ap) {
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        this.E.getOffspring(ap.getMac(), hashSet);
        if (!CollectionUtils.isEmpty(hashSet)) {
            for (String string : hashSet) {
                if (!com.tp_link.eap.monitor.monitor.realtime.c.d(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transManagedOther(String mac) {
        Object object;
        if (com.tp_link.eap.util.a.e.a((String)mac)) {
            return;
        }
        com.tp_link.eap.d.b.d((String)mac);
        com.tp_link.eap.monitor.monitor.realtime.a.b(mac);
        com.tp_link.eap.monitor.monitor.realtime.a.d(mac);
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)mac);
        synchronized (object2) {
            Ap ap = this.getApByMac(mac);
            if (ap != null) {
                ap.setSite("PENDING-SITE");
                ap.setAdopted(false);
                ap.setAdoptStatus(0);
                ap.setStatus(Integer.valueOf(2));
                ap.setAdoptInfo(null);
                ap.setManagedMark(2);
                if (ap.getWirelessLinked().booleanValue()) {
                    ap.setIp(null);
                    ap.setVersion(null);
                    ap.setStatusWireless(Integer.valueOf(1));
                }
                com.tp_link.eap.a.b.a((Ap)ap);
                this.refreshAp(ap);
            }
        }
        this.clearStatistics(mac);
        CacheTask.a.a(mac);
        if (com.tp_link.eap.h.d.c.d((String)mac)) {
            com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, mac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStatus(String mac, Integer status) {
        Object object;
        if (com.tp_link.eap.util.a.e.a((String)mac) || status < 0) {
            return false;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)mac);
        synchronized (object2) {
            Ap ap = this.i.findByMac(mac);
            ap.setStatus(status);
            this.refreshAp(ap);
        }
        return true;
    }

    @Override
    public long countMeshAp(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.i.countMeshAp(filters, searchFilters);
    }

    @Override
    public List<Ap> getMeshAp(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Ap> list = this.i.getMeshAp(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Ap ap = list.get(i2);
            ap.setSca(this.j.findByApMac(ap.getMac()));
            list.set(i2, ap);
        }
        this.f(list);
        return list;
    }

    private void f(List<Ap> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                Ap ap2;
                if (ap.getWirelessLinked().booleanValue()) {
                    ap.setHop(this.E.getHop(ap.getMac()));
                } else {
                    ap.setHop(0);
                }
                if (ap.getWp5g() == null || com.tp_link.eap.util.l.h((String)ap.getWp5g().getActualChannel()) == -1) {
                    ap.setChannel5G("-");
                } else {
                    ap.setChannel5G("" + com.tp_link.eap.util.l.h((String)ap.getWp5g().getActualChannel()));
                }
                ap.setUplink("");
                if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac()) && (ap2 = this.getApByMac(ap.getMeshConf().getParentApMac())) != null) {
                    ap.setUplink(ap2.getName());
                }
                ap.setDownlink(0);
                if (ap.getMeshConf() == null || CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) continue;
                ap.setDownlink(ap.getMeshConf().getChildApMacs().size());
            }
        }
    }

    @Override
    public void handleMeshTask() {
        this.e();
        this.f();
        this.doFailoverTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() {
        List<Ap> list = this.i.findByStatusAndWirelessLinked(2, true);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                CandidateParentApInfo candidateParentApInfo;
                Object object;
                Object object2;
                HashSet<String> hashSet = new HashSet<String>();
                StatMeshInfo statMeshInfo = this.E.getStatMeshByMac(ap.getMac());
                if (statMeshInfo != null && !CollectionUtils.isEmpty((Collection)(object2 = statMeshInfo.getCandidateParentAps()))) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        candidateParentApInfo = (CandidateParentApInfo)object.next();
                        Ap ap2 = this.getApByMac(candidateParentApInfo.getMac());
                        if (ap2 == null || ap2.getStatus() != 1 || com.tp_link.eap.util.l.a((long)candidateParentApInfo.getUptime().getTime(), (long)60000L)) continue;
                        hashSet.add(ap2.getSite());
                    }
                }
                if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac()) && (object2 = this.getApByMac(ap.getMeshConf().getParentApMac())) != null) {
                    hashSet.add(object2.getSite());
                }
                object = object2 = com.tp_link.eap.b.b.a.a((String)ap.getMac());
                synchronized (object) {
                    candidateParentApInfo = this.i.findByMac(ap.getMac());
                    if (candidateParentApInfo != null) {
                        ap.setWirelessPendingSite(hashSet);
                        this.i.save(candidateParentApInfo);
                    }
                }
            }
        }
    }

    private void f() {
        List<StatMeshInfo> list = this.E.getListByStatus(1);
        if (!CollectionUtils.isEmpty(list)) {
            for (StatMeshInfo statMeshInfo : list) {
                Ap ap;
                if (statMeshInfo.getTryTime() == null || !com.tp_link.eap.util.l.a((long)statMeshInfo.getTryTime().getTime(), (long)150000L) || (ap = this.getApByMac(statMeshInfo.getMac())) != null && ap.getStatus() == 2 && ap.getStatus() == 1) continue;
                ae.debug("disConnectParentAp {}", (Object)statMeshInfo.getMac());
                this.E.disConnectParentAp(statMeshInfo.getMac(), statMeshInfo.getTryParent(), false, false, false);
                this.E.refreshStatus(statMeshInfo.getMac(), 3);
                MeshFailoverRecord.removeParentRecord((String)statMeshInfo.getTryParent());
                MeshFailoverRecord.addChildRecord((String)statMeshInfo.getMac());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forgetWirelessPendingSite(String site) {
        List<Ap> list = this.i.findByStatusAndWirelessLinked(2, true);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                Object object;
                Set set = ap.getWirelessPendingSite();
                if (!CollectionUtils.isEmpty((Collection)set) && set.contains(site)) {
                    Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
                    synchronized (object2) {
                        Set set2;
                        Ap ap2 = this.i.findByMac(ap.getMac());
                        if (ap2 != null && !CollectionUtils.isEmpty((Collection)(set2 = ap2.getWirelessPendingSite())) && set2.contains(site)) {
                            set2.remove(site);
                            if (CollectionUtils.isEmpty((Collection)set2)) {
                                this.i.delete(ap2);
                            } else {
                                this.i.save(ap2);
                            }
                        }
                    }
                }
                if (ap == null || !ap.getWirelessLinked().booleanValue() || ap.getAdoptStatus() != 1 || (object = this.E.getStatMeshByMac(ap.getMac())) != null && (object.getTryTime() == null || !com.tp_link.eap.util.l.a((long)object.getTryTime().getTime(), (long)400000L))) continue;
                ae.debug("pending mesh not work", (Object)ap.getMac());
                com.tp_link.eap.monitor.monitor.realtime.a.f(ap.getMac());
                this.setApAdoptStatus(ap.getMac(), 2);
                this.setStatusWireless(ap.getMac(), 1);
                this.disconnectChildAp(ap.getMac(), false);
            }
        }
    }

    @Override
    public void sendSettingImmediately(String site, String settingTarget, Object settingContent) {
        Object object;
        if (com.tp_link.eap.util.a.e.a((String)site) || com.tp_link.eap.util.a.e.a((String)settingTarget) || settingContent == null) {
            return;
        }
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setSequenceId(Integer.valueOf(65542));
        if (settingTarget.equals("managementVlan")) {
            object = (ManagementVlanConfig)settingContent;
            eapConfigBody.setManagementVlan((ManagementVlanConfig)object);
            eapConfigBody.setSequenceId(Integer.valueOf(65543));
        }
        if (!CollectionUtils.isEmpty((Map)(object = this.E.getApMapByHop(site)))) {
            for (int i2 = 3; i2 >= 0; --i2) {
                List list = (List)object.get(i2);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                HashSet<String> hashSet = new HashSet<String>();
                for (MeshRelation meshRelation : list) {
                    if (meshRelation.getStatus() != 1) continue;
                    hashSet.add(meshRelation.getMac());
                }
                ae.debug(((Object)hashSet).toString());
                com.tp_link.eap.util.o.b.a((Integer)65543, hashSet);
                for (MeshRelation meshRelation : list) {
                    ae.debug(meshRelation.getMac());
                    if (meshRelation.getStatus() == 1) {
                        Integer n2 = this.y.getSettingVersion(meshRelation.getMac()).getBase();
                        eapConfigBody.setConfigVersion(n2);
                        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, meshRelation.getMac());
                    }
                    this.y.refreshVersion(meshRelation.getMac());
                }
                if (i2 <= 0) continue;
                for (int i3 = 0; com.tp_link.eap.util.o.b.c((Integer)65543, hashSet) != 2 && i3 < com.tp_link.eap.c.a.f; ++i3) {
                    try {
                        Thread.sleep(com.tp_link.eap.c.a.e);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        ae.warn(interruptedException.toString(), (Throwable)interruptedException);
                    }
                }
                com.tp_link.eap.util.o.b.b((Integer)65543, hashSet);
            }
        }
    }

    @Override
    public boolean getMeshChannelLimit(String mac) {
        if (com.tp_link.eap.util.a.e.a((String)mac)) {
            return false;
        }
        Ap ap = this.getApByMac(mac);
        Ap ap2 = null;
        if (ap != null && ap.getWirelessLinked().booleanValue() && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            ap2 = this.getApByMac(ap.getMeshConf().getParentApMac());
        }
        if (ap2 == null) {
            if (ap != null && ap.getRadio5g() != null) {
                return ap.getRadio5g().isChannelLimitEnable();
            }
            return false;
        }
        if (!com.tp_link.eap.util.l.e((DeviceMisc)ap2.getDeviceMisc())) {
            return false;
        }
        while (ap != null && ap.getWirelessLinked().booleanValue() && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            if ((ap = this.getApByMac(ap.getMeshConf().getParentApMac())) != null && com.tp_link.eap.util.l.e((DeviceMisc)ap.getDeviceMisc())) continue;
            return false;
        }
        if (ap != null && !ap.getMac().equals(mac) && !ap.getWirelessLinked().booleanValue() && ap.getRadio5g() != null) {
            return ap.getRadio5g().isChannelLimitEnable();
        }
        return false;
    }

    @Override
    public List<String> getUpgradeableAps(String site, String modelModelVersion) {
        List<Ap> list = this.b(site, modelModelVersion);
        ae.debug("db modelAps.size = " + list.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Ap ap : list) {
            if (ap.getRealtimeStatus() != RealtimeStatus.a.a()) continue;
            arrayList.add(ap.getMac());
        }
        return arrayList;
    }

    @Override
    public List<String> getSupportModel(String site) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        List<Ap> list = StringUtils.isEmpty((String)site) ? this.getAdoptAps() : this.getSiteAdoptedAps(site);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                if (com.tp_link.eap.util.a.e.a((String)ap.getModelModelVersion()) || hashMap.get(ap.getModelModelVersion()) != null) continue;
                hashMap.put(ap.getModelModelVersion(), true);
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public OperationResponse getApRadio(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        Ap ap = this.getApDetail(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("radio", this.a(0, ap));
        if (com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
            hashMap.put("radio5g", this.a(1, ap));
        } else {
            hashMap.put("radio5g", null);
        }
        hashMap.put("deviceMisc", (Object)DeviceMiscModel.convertFromDeviceMisc(ap.getDeviceMisc()));
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getApLoadBalance(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        LoadBalanceModel loadBalanceModel = LoadBalanceModel.convertFromLoadBalanceAndRssi(ap.getLoadBalance(), ap.getRssi());
        LoadBalanceModel loadBalanceModel2 = LoadBalanceModel.convertFromLoadBalanceAndRssi(ap.getLoadBalance5g(), ap.getRssi5g());
        HashMap<String, LoadBalanceModel> hashMap = new HashMap<String, LoadBalanceModel>();
        hashMap.put("loadBalance2_4g", loadBalanceModel);
        hashMap.put("loadBalance5g", loadBalanceModel2);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getGridApsAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.J.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            ae.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        com.tp_link.eap.d.b.b((String)"Default");
        return this.getGridAps(controlType, reqObj);
    }

    @Override
    public OperationResponse getGridSimpleModelApsAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.J.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            ae.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        com.tp_link.eap.d.b.b((String)"Default");
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid<Ap> grid = this.a(queryData);
        List list = grid.getData();
        ArrayList<ApInfo> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<ApInfo>();
            for (Ap ap : list) {
                ApInfo apInfo = ApInfo.convertFromApSimpleModel(ap);
                arrayList.add(apInfo);
            }
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, grid);
    }

    @Override
    public OperationResponse getBriefApDetail(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        Ap ap = this.i.findByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        ApBriefInfo apBriefInfo = ApBriefInfo.convertFromAp(ap);
        apBriefInfo.setCanOnlineUpgrade(this.c(ap));
        apBriefInfo.setUpgrading(this.d(ap));
        if (ap.getStatus() != 2) {
            apBriefInfo.setClientNum(this.b(ap.getMac(), false));
            apBriefInfo.setGuestNum(this.b(ap.getMac(), true));
        }
        return new OperationResponse(ResErrorCode.a, (Object)apBriefInfo);
    }

    @Override
    public OperationResponse getGridApsBriefInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid<Ap> grid = this.a(queryData);
        List list = grid.getData();
        if (list != null && !list.isEmpty()) {
            ArrayList<ApGridBriefInfo> arrayList = new ArrayList<ApGridBriefInfo>();
            for (Ap ap : list) {
                ApGridBriefInfo apGridBriefInfo = this.a(ap);
                arrayList.add(apGridBriefInfo);
            }
            grid.setData(arrayList);
        }
        return new OperationResponse(ResErrorCode.a, grid);
    }

    @Override
    public OperationResponse getApIPSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        Ap ap = this.i.findByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        IpSetting ipSetting = ap.getIpSetting();
        return new OperationResponse(ResErrorCode.a, (Object)ipSetting);
    }

    @Override
    public OperationResponse getApWlanGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            ae.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        Ap ap = this.i.findByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("wlanGroupId2G", ap.getWlanGroupId2G());
        hashMap.put("wlanGroupId5G", ap.getWlanGroupId5G());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse setApLocatingStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.getJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || !(jSONObject.get("apMac") instanceof String)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        if (!jSONObject.containsKey((Object)"isLocating") || !(jSONObject.get("isLocating") instanceof Boolean)) {
            return com.tp_link.eap.util.e.aZ;
        }
        boolean bl = jSONObject.getBoolean("isLocating");
        return this.setApLocatingStatus(string, bl);
    }

    @Override
    public OperationResponse setApLocatingStatus(String apMac, boolean isLocating) {
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        hashMap.put("isLocating", Boolean.valueOf(isLocating));
        hashMap.put("timestamp", isLocating ? Long.valueOf(System.currentTimeMillis()) : null);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getApLocatingStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.getJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || !(jSONObject.get("apMac") instanceof String)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        return this.getApLocatingStatus(string);
    }

    @Override
    public OperationResponse getApLocatingStatus(String apMac) {
        boolean bl = false;
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        hashMap.put("isLocating", Boolean.valueOf(bl));
        hashMap.put("timestamp", bl ? Long.valueOf(System.currentTimeMillis()) : null);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse setApLedStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.getJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || !(jSONObject.get("apMac") instanceof String)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        if (!jSONObject.containsKey((Object)"ledStatus") || !(jSONObject.get("ledStatus") instanceof Number)) {
            return com.tp_link.eap.util.e.aZ;
        }
        int n2 = jSONObject.getInt("ledStatus");
        return this.setApLedStatus(string, n2);
    }

    @Override
    public OperationResponse setApLedStatus(String apMac, int ledStatus) {
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getApLedStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.getJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || !(jSONObject.get("apMac") instanceof String)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        return this.getApLedStatus(string);
    }

    @Override
    public OperationResponse getApLedStatus(String apMac) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("ledStatus", 2);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    public static String buildEAPFwFileDir(String modelModelVersion) {
        String string = System.getProperty("eap.home", ".") + File.separatorChar + a + File.separatorChar + modelModelVersion.replace("/", "%");
        return string;
    }

    public static String restoreModelModelVersion(String dirName) {
        return dirName.replace("%", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(ControlType controlType, String string, String string2, byte[] byArray, int n2) {
        Ap ap;
        Object object;
        Object object2;
        Object object3;
        if (controlType != null) {
            if (com.tp_link.eap.monitor.monitor.realtime.d.b(string, string2)) {
                return new OperationResponse(ResErrorCode.by);
            }
            object3 = this.Z;
            synchronized (object3) {
                object2 = this.aa.get(string2);
                if (object2 != null && (object = ((q)object2).c()) != null && !object.isDone()) {
                    object.cancel(true);
                }
            }
        }
        if ((object3 = com.tp_link.eap.monitor.monitor.upgrade.a.a(string)) != null && object3.getValue() != null) {
            return new OperationResponse(ResErrorCode.by);
        }
        object2 = this.b(string, string2);
        if (n2 == 1) {
            object = object2.iterator();
            while (object.hasNext()) {
                ap = (Ap)object.next();
                if (this.c(ap)) continue;
                ae.info("Firmware version({}) of ap({}) shouldn't be upgraded by cloud firmware.", (Object)ap.getVersion(), (Object)ap.getMac());
                object.remove();
            }
        }
        object = new ArrayList();
        ap = object2.iterator();
        while (ap.hasNext()) {
            Ap ap2 = (Ap)ap.next();
            if (ap2.getRealtimeStatus() != RealtimeStatus.a.a()) continue;
            object.add(ap2.getMac());
        }
        if (object.isEmpty()) {
            return new OperationResponse(ResErrorCode.bq);
        }
        ap = com.tp_link.eap.monitor.monitor.upgrade.a.a.a(byArray);
        if (!ap.success()) {
            return ap;
        }
        return this.upgrade((List<String>)object, byArray, string, string2);
    }

    private ApGridBriefInfo a(Ap ap) {
        if (ap == null) {
            return null;
        }
        ApGridBriefInfo apGridBriefInfo = new ApGridBriefInfo();
        BeanUtils.copyProperties((Object)ap, (Object)apGridBriefInfo);
        apGridBriefInfo.setRunTime(this.c(ap.getUptime()));
        apGridBriefInfo.setIsSupport5g(com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel()));
        apGridBriefInfo.setIsUpgrading(this.d(ap));
        apGridBriefInfo.setCanOnlineUpgrade(this.c(ap));
        apGridBriefInfo.setIsUplinkWireless(Boolean.TRUE.equals(ap.getWirelessLinked()));
        return apGridBriefInfo;
    }

    private long c(String string) {
        long l2 = 0L;
        try {
            String[] stringArray;
            if (string != null && (stringArray = string.split(" days |:")).length == 4) {
                l2 = Long.valueOf(stringArray[0]) * 86400L + Long.valueOf(stringArray[1]) * 3600L + Long.valueOf(stringArray[2]) * 60L + Long.valueOf(stringArray[3]);
            }
        }
        catch (Exception exception) {
            ae.warn("Convert AP runtime failed.", (Throwable)exception);
        }
        return l2;
    }

    private RadioModel a(int n2, Ap ap) {
        ArrayList<RegionParamModel> arrayList;
        List list;
        Radio radio;
        if (ap == null) {
            return null;
        }
        Radio radio2 = radio = n2 == 0 ? ap.getRadio() : ap.getRadio5g();
        if (radio == null) {
            return null;
        }
        RadioModel radioModel = new RadioModel();
        DeviceMisc deviceMisc = ap.getDeviceMisc();
        radioModel.setRadioEnable(radio.isRadioEnable());
        radioModel.setRadioMode(Integer.valueOf(radio.getRadioMode()));
        radioModel.setChannelWidth(Integer.valueOf(radio.getChannelWidth()));
        radioModel.setChannel(Integer.valueOf(radio.getChannel()));
        WirelessParam wirelessParam = n2 == 0 ? ap.getWp2g() : ap.getWp5g();
        radioModel.setActualChannel(wirelessParam != null ? wirelessParam.getActualChannel() : "N/A");
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"radioId").is((Object)n2)).addCriteria(Criteria.where((String)"apMac").is((Object)ap.getMac())).addCriteria(Criteria.where((String)"isActive").is((Object)true)).addCriteria(Criteria.where((String)"isGuest").is((Object)false));
        long l2 = this.p.count(query, Client.class);
        query = new Query();
        query.addCriteria(Criteria.where((String)"radioId").is((Object)n2)).addCriteria(Criteria.where((String)"apMac").is((Object)ap.getMac())).addCriteria(Criteria.where((String)"isActive").is((Object)true)).addCriteria(Criteria.where((String)"isGuest").is((Object)true));
        long l3 = this.p.count(query, Client.class);
        radioModel.setUserNum((int)l2);
        radioModel.setGuestNum((int)l3);
        StatCurrentAp statCurrentAp = ap.getSca();
        if (statCurrentAp == null) {
            radioModel.setUpload(0L);
            radioModel.setDownload(0L);
        } else if (n2 == 0) {
            radioModel.setUpload(statCurrentAp.getUpload2g());
            radioModel.setDownload(statCurrentAp.getDownload2g());
        } else if (n2 == 1) {
            radioModel.setUpload(statCurrentAp.getUpload5g());
            radioModel.setDownload(statCurrentAp.getDownload5g());
        }
        radioModel.setSupportChannelLimit(n2 == 1 && Boolean.TRUE.equals(deviceMisc.getSupportChannelLimit()));
        radioModel.setChannelLimitEnable(radio.isChannelLimitEnable());
        radioModel.setTxPower(radio.getTxPower());
        radioModel.setTxPowerLevel(radio.getTxPowerLevel());
        radioModel.setRadioModeList(this.a(n2, deviceMisc.getSupport11ac()));
        Integer n3 = deviceMisc.getCustomizeRegion();
        List<List<RegionWireParam>> list2 = this.x.getRegionWireParams(n3);
        if (n2 == 0 || n2 == 1) {
            list = list2.get(n2);
            arrayList = null;
            if (!CollectionUtils.isEmpty(list)) {
                arrayList = new ArrayList<RegionParamModel>();
                for (RegionWireParam regionWireParam : list) {
                    arrayList.add(RegionParamModel.convertFromRegionParam(regionWireParam));
                }
            }
            radioModel.setChannelList(arrayList);
        }
        if (n2 == 1 && (deviceMisc.getSupportDfs() != null || Boolean.TRUE.equals(deviceMisc.getSupportChannelLimit()))) {
            list = com.tp_link.eap.util.j.b.c((String)com.tp_link.eap.util.j.a.a((Integer)n3));
            arrayList = null;
            if (list != null) {
                arrayList = new ArrayList();
                for (RegionWireParam regionWireParam : list) {
                    arrayList.add(RegionParamModel.convertFromRegionParam(regionWireParam));
                }
            }
            radioModel.setChannelLimitList(arrayList);
        }
        return radioModel;
    }

    private List<Integer> a(int n2, Boolean bl) {
        List<Integer> list = n2 == 0 ? Arrays.asList(RadioMode.N.value, RadioMode.B_G.value, RadioMode.B_G_N.value) : (Boolean.TRUE.equals(bl) ? Arrays.asList(RadioMode.AC.value, RadioMode.N_AC.value, RadioMode.A_N_AC.value) : Arrays.asList(RadioMode.N.value, RadioMode.A.value, RadioMode.A_N.value));
        return list;
    }

    private List<Ap> b(String string, String string2) {
        return this.i.findBySiteAndStatusAndModelModelVersion(string, 1, string2);
    }

    private ResErrorCode g() {
        if (com.tp_link.eap.util.l.b()) {
            if (!this.n.checkCloudAccessEnable()) {
                return ResErrorCode.et;
            }
            CloudUser cloudUser = this.o.getOwner();
            if (cloudUser == null || StringUtils.isBlank((String)cloudUser.getAccountName())) {
                return ResErrorCode.ey;
            }
        }
        return ResErrorCode.a;
    }

    private boolean d(String string) {
        q q2 = this.aa.get(string);
        if (q2 == null || q2.a() == null) {
            return false;
        }
        return !q2.a().isDone();
    }

    private String b(Ap ap) {
        DeviceMisc deviceMisc = ap.getDeviceMisc();
        if (deviceMisc != null && deviceMisc.getCustomizeRegion() != null) {
            return com.tp_link.eap.util.j.a.a((Integer)deviceMisc.getCustomizeRegion());
        }
        return com.tp_link.eap.util.j.a.a((Integer)841);
    }

    private boolean c(Ap ap) {
        if (ap == null || ap.getStatus() == 2) {
            return false;
        }
        if (com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion())) {
            return false;
        }
        ModelFw modelFw = this.m.getModelInfo(ap.getModelModelVersion());
        return modelFw != null && com.tp_link.eap.monitor.c.a.a(ap.getVersion(), modelFw.getLastFwVer()) < 0;
    }

    private ResErrorCode a(boolean bl, String string, String string2) {
        ResErrorCode resErrorCode = ResErrorCode.b;
        DeviceInfo deviceInfo = com.tp_link.eap.util.l.b() ? new com.tp_link.eap.monitor.cloud.device.b().getDeviceInfo() : new com.tp_link.eap.monitor.cloud.device.a().getDeviceInfo();
        ModelFw modelFw = this.m.getModelInfo(string);
        long l2 = System.currentTimeMillis() / 1000L;
        if (modelFw == null || StringUtils.isBlank((String)modelFw.getEncryptedHwId()) || StringUtils.isBlank((String)modelFw.getEncryptedOemId())) {
            modelFw = com.tp_link.eap.monitor.c.a.a(string);
            if (modelFw == null || StringUtils.isBlank((String)modelFw.getEncryptedHwId()) || StringUtils.isBlank((String)modelFw.getEncryptedOemId())) {
                ae.warn("Failed to get model information from local map file for model({}).", (Object)string);
                return ResErrorCode.a;
            }
            modelFw.setCategory(ModelFw.DeviceCategory.EAP.getCategory());
        } else if (bl && l2 - modelFw.getManualCheckTime() < 86400L && l2 >= modelFw.getManualCheckTime()) {
            ae.debug("The time since last fw check time of modelModelVersion({}) is less than 24 hours.", (Object)modelFw.getModelModelVersion());
            resErrorCode = ResErrorCode.a;
            return resErrorCode;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"deviceId", (Object)deviceInfo.getDeviceId());
        jSONObject.put((Object)"hwId", (Object)com.tp_link.eap.monitor.cloud.e.a.d(modelFw.getEncryptedHwId()));
        jSONObject.put((Object)"oemId", (Object)com.tp_link.eap.monitor.cloud.e.a.d(modelFw.getEncryptedOemId()));
        jSONObject.put((Object)"fwId", (Object)"");
        jSONObject.put((Object)"devFwCurrentVer", (Object)com.tp_link.eap.monitor.c.a.c(string2));
        jSONObject.put((Object)"locale", (Object)"en_US");
        JSONObject jSONObject2 = null;
        try {
            jSONObject2 = com.tp_link.eap.monitor.cloud.d.b.b.a(jSONObject);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ae.debug(socketTimeoutException.toString(), (Throwable)socketTimeoutException);
            resErrorCode = ResErrorCode.eJ;
        }
        catch (SocketException | UnknownHostException iOException) {
            ae.debug(iOException.toString(), (Throwable)iOException);
            resErrorCode = ResErrorCode.eL;
        }
        catch (IOException iOException) {
            ae.info("Exception occurs when sending request('{}'): {}.", (Object)"getFwVersionsForDevice", (Object)iOException.toString());
            ae.debug(iOException.toString(), (Throwable)iOException);
        }
        if (jSONObject2 != null) {
            try {
                int n2 = jSONObject2.getInt("error_code");
                if (n2 == 0) {
                    JSONObject jSONObject3 = jSONObject2.getJSONObject("result");
                    JSONArray jSONArray = jSONObject3.optJSONArray("fwVersions");
                    resErrorCode = ResErrorCode.a;
                    JSONObject jSONObject4 = null;
                    Configuration configuration = com.tp_link.eap.configuration.a.a((String)"eap.properties");
                    String string3 = configuration.getProperty("eap.version");
                    if (jSONArray != null) {
                        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                            JSONObject jSONObject5 = jSONArray.getJSONObject(i2);
                            String string4 = jSONObject5.optString("fwAddition");
                            if (!StringUtils.isBlank((String)string4) && com.tp_link.eap.monitor.c.a.a(string3, string4) < 0) continue;
                            String string5 = null;
                            String string6 = jSONObject5.getString("fwVer");
                            if (jSONObject4 != null) {
                                string5 = jSONObject4.getString("fwVer");
                            }
                            if (!StringUtils.isBlank(string5) && com.tp_link.eap.monitor.c.a.a(string6, string5) <= 0) continue;
                            jSONObject4 = jSONObject5;
                        }
                    }
                    if (jSONObject4 != null) {
                        modelFw.setLastFwVer(jSONObject4.getString("fwVer"));
                        if (bl) {
                            modelFw.setManualCheckTime(l2);
                        }
                        if (jSONObject4.has(V)) {
                            modelFw.setFwReleaseLog(jSONObject4.getString(V));
                        }
                        if (jSONObject4.has("fwTitle")) {
                            modelFw.setFwTitle(jSONObject4.getString("fwTitle"));
                        }
                        modelFw.setFwType(jSONObject4.getInt("fwType"));
                        String string7 = jSONObject4.getString("fwUrl");
                        modelFw.setFwUrl(string7);
                        modelFw.setFwMD5(jSONObject4.getString("fwMD5"));
                        this.m.refreshModelInfo(modelFw);
                    }
                    return resErrorCode;
                }
            }
            catch (JSONException jSONException) {
                ae.warn(jSONException.toString(), (Throwable)jSONException);
            }
        }
        return resErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResErrorCode a(String string, com.tp_link.eap.monitor.c.c c2, boolean bl) {
        String string2 = ApService.buildEAPFwFileDir(string);
        ModelFw modelFw = this.m.getModelInfo(string);
        if (modelFw != null && !StringUtils.isBlank((String)modelFw.getFwUrl())) {
            String string3 = com.tp_link.eap.monitor.c.a.f(modelFw.getFwUrl());
            String string4 = string2 + File.separatorChar + string3;
            Object object = this.Z;
            synchronized (object) {
                Future<Void> future;
                if (this.d(string)) {
                    ae.info("Some AP is upgrading, please retry later.");
                    return ResErrorCode.dr;
                }
                boolean bl2 = com.tp_link.eap.monitor.c.a.g(string4);
                boolean bl3 = false;
                String string5 = null;
                try {
                    if (bl2) {
                        future = new FileInputStream(string4);
                        string5 = DigestUtils.md5Hex((InputStream)((Object)future)).toUpperCase(Locale.ROOT);
                        ((InputStream)((Object)future)).close();
                    }
                }
                catch (IOException iOException) {
                    ae.warn(iOException.toString());
                    ae.debug(iOException.toString(), (Throwable)iOException);
                }
                if (!StringUtils.isBlank(string5) && !StringUtils.isBlank((String)modelFw.getFwMD5()) && string5.equals(modelFw.getFwMD5())) {
                    bl3 = true;
                }
                if (!bl2 || !bl3) {
                    AtomicInteger atomicInteger;
                    com.tp_link.eap.monitor.c.a.d(string2);
                    future = this.aa.get(string);
                    if (future != null) {
                        atomicInteger = ((q)((Object)future)).b();
                        atomicInteger.set(0);
                        ((q)((Object)future)).a(ResErrorCode.a);
                    } else {
                        future = new q();
                        atomicInteger = new AtomicInteger();
                        ((q)((Object)future)).a(atomicInteger);
                    }
                    this.aa.put(string, (q)((Object)future));
                    c c3 = new c(this, c2, string, string4);
                    com.tp_link.eap.monitor.c.d d2 = new com.tp_link.eap.monitor.c.d(modelFw.getFwUrl(), string4, atomicInteger, c3);
                    Future<Boolean> future2 = this.ad.submit(d2);
                    ((q)((Object)future)).a(future2);
                } else {
                    ae.info("Firmware file of model({}) has already existed, so needn't be downloaded.", (Object)string);
                    future = null;
                    if (bl) {
                        ExecutorService executorService = Executors.newFixedThreadPool(1);
                        future = executorService.submit(new r(this, string));
                        executorService.shutdown();
                    }
                    this.aa.put(string, new q(null, new AtomicInteger(100), future));
                }
                return ResErrorCode.a;
            }
        }
        ae.info("Invalid model firmware info of EAP.");
        return ResErrorCode.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean e(String string) {
        Object object = this.Z;
        synchronized (object) {
            o o2 = this.ab.get(string);
            if (o2 == null) {
                ae.warn("Information of online upgrading AP({}) doesn't exist.", (Object)string);
                return true;
            }
            ResErrorCode resErrorCode = o2.b();
            if (!resErrorCode.equals((Object)ResErrorCode.a)) {
                ae.warn("Failed to online upgrade AP({}).", (Object)string);
                return true;
            }
            p p2 = o2.d();
            if (p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.e)) {
                ae.info("Succeed to online upgrade AP({}).", (Object)string);
                return true;
            }
            if (!p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.d)) return false;
            if (!SingleUpgradeResult.c(string)) return false;
            ae.info("Operation of online upgrading AP({}) is finished.", (Object)string);
            return true;
        }
    }

    private void g(List<MeshRelation> list) {
        Ap ap;
        MeshRelation meshRelation2;
        if (list.isEmpty()) {
            return;
        }
        TreeSet<Ap> treeSet = new TreeSet<Ap>(new d(this));
        for (MeshRelation meshRelation2 : list) {
            ae.debug("Checked mac of meshRelation for upgrading is {}", (Object)meshRelation2.getMac());
            ap = this.getApByMac(meshRelation2.getMac());
            if (ap == null || StringUtils.isBlank((String)ap.getModelModelVersion()) || ap.getStatus() != 1 || !this.c(ap)) continue;
            treeSet.add(ap);
            ae.debug("Added mac of meshRelation for upgrading is {}", (Object)ap.getMac());
        }
        Iterator<Object> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            meshRelation2 = (Ap)iterator.next();
            ae.debug("Upgraded mac is {}", (Object)meshRelation2.getMac());
            ap = this.f(meshRelation2.getMac());
            if (ap.equals((Object)ResErrorCode.a)) continue;
            iterator.remove();
        }
        while (treeSet.size() > 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                ae.warn(interruptedException.toString(), (Throwable)interruptedException);
            }
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                meshRelation2 = (Ap)iterator.next();
                if (!this.e(meshRelation2.getMac())) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResErrorCode f(String string) {
        ResErrorCode resErrorCode;
        if (StringUtils.isBlank((String)string)) {
            return ResErrorCode.d;
        }
        Ap ap = this.getApByMac(string);
        if (ap == null) {
            ae.warn("Can't find a matched ap by mac({}).", (Object)string);
            return ResErrorCode.d;
        }
        if (!com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion())) {
            Object object = this.Z;
            synchronized (object) {
                q q2;
                o o2 = this.ab.get(string);
                if (o2 == null) {
                    o2 = new o(this, null);
                    this.ab.put(string, o2);
                }
                o2.a(string);
                o2.a(ResErrorCode.a);
                o2.b(null);
                o2.a(com.tp_link.eap.monitor.monitor.service.impl.p.a);
                o2.f().set(0);
                e e2 = new e(this, string, ap);
                resErrorCode = this.a(ap.getModelModelVersion(), e2, false);
                if (resErrorCode.equals((Object)ResErrorCode.a) && (q2 = this.aa.get(ap.getModelModelVersion())) != null && q2.b().get() >= 100) {
                    this.e(ap);
                }
            }
        } else {
            ae.warn("Firmware version({}) of model({}) of ap({}) is in incompatible firmware versions, so online upgrading is forbidden.", new Object[]{ap.getVersion(), ap.getModelModelVersion(), ap.getMac()});
            resErrorCode = ResErrorCode.dq;
        }
        return resErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean d(Ap ap) {
        if (ap == null || ap.getStatus() == 2) {
            return false;
        }
        Object object = this.Z;
        synchronized (object) {
            p p2;
            ResErrorCode resErrorCode;
            o o2 = this.ab.get(ap.getMac());
            if (o2 != null && (resErrorCode = o2.b()).equals((Object)ResErrorCode.a) && !(p2 = o2.d()).equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.a) && !p2.equals((Object)com.tp_link.eap.monitor.monitor.service.impl.p.e)) {
                return true;
            }
        }
        return ap.getRealtimeStatus() == RealtimeStatus.c.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(Ap ap) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ap.getMac());
        byte[] byArray = this.g(ap.getModelModelVersion());
        Object object = this.Z;
        synchronized (object) {
            o o2 = this.ab.get(ap.getMac());
            o2.a(com.tp_link.eap.monitor.monitor.service.impl.p.c);
            AtomicInteger atomicInteger = o2.f();
            int n2 = 30;
            atomicInteger.set(n2);
            OperationResponse operationResponse = this.upgrade(arrayList, byArray, null, null);
            if (operationResponse.getErrorCode() == ResErrorCode.a.a()) {
                o2.a(com.tp_link.eap.monitor.monitor.service.impl.p.d);
                this.ad.execute(() -> {
                    SingleUpgradeResult$UpgradeResult singleUpgradeResult$UpgradeResult;
                    long l2 = 0L;
                    long l3 = com.tp_link.eap.monitor.monitor.upgrade.a.a(byArray.length);
                    long l4 = com.tp_link.eap.monitor.monitor.upgrade.a.a();
                    long l5 = 1L;
                    do {
                        try {
                            Thread.sleep(l5 * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            ae.warn(interruptedException.toString(), (Throwable)interruptedException);
                        }
                        atomicInteger.set(n2 + (int)((double)((l2 += l5) * 100L) * 0.7 / (double)(l2 + l3 + l4)));
                    } while (!(singleUpgradeResult$UpgradeResult = SingleUpgradeResult.d(ap.getMac())).isAllFinished());
                    OperationResult operationResult = singleUpgradeResult$UpgradeResult.getResult();
                    if (operationResult == null || !operationResult.isSuccess()) {
                        singleUpgradeResult$UpgradeResult = (ResErrorCode)operationResult.getValue();
                        Object object = this.Z;
                        synchronized (object) {
                            if (singleUpgradeResult$UpgradeResult != null) {
                                o2.a((ResErrorCode)singleUpgradeResult$UpgradeResult);
                            } else {
                                o2.a(ResErrorCode.b);
                            }
                            o2.b(operationResult.getMessage());
                        }
                        return;
                    }
                    long l6 = l2;
                    for (long i2 = l3 + l4; i2 > 0L; i2 -= l5) {
                        try {
                            Thread.sleep(l5 * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            ae.warn(interruptedException.toString(), (Throwable)interruptedException);
                        }
                        atomicInteger.set(n2 + (int)((double)((l2 += l5) * 100L) * 0.7 / (double)(l6 + l3 + l4)));
                    }
                    Object object = this.Z;
                    synchronized (object) {
                        o2.a(com.tp_link.eap.monitor.monitor.service.impl.p.e);
                    }
                });
            } else {
                o2.a(ResErrorCode.a((int)operationResponse.getErrorCode()));
                o2.b(operationResponse.getMsg());
            }
        }
    }

    private byte[] g(String string) {
        String string2 = ApService.buildEAPFwFileDir(string);
        File file = new File(string2);
        String[] stringArray = file.list(new f(this));
        if (stringArray == null || stringArray.length != 1) {
            ae.warn("Can't find a valid firmware or select one from more than one.");
            com.tp_link.eap.monitor.c.a.d(string2);
            return null;
        }
        Path path = Paths.get(string2 + File.separatorChar + stringArray[0], new String[0]);
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            ae.warn(iOException.toString(), (Throwable)iOException);
            return null;
        }
    }

    private Map<String, String> h(String string) {
        List<Ap> list = StringUtils.isEmpty((String)string) ? this.getAdoptAps() : this.getSiteAdoptedAps(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(list)) {
            Iterator<Ap> iterator = list.iterator();
            while (iterator.hasNext()) {
                Ap ap = iterator.next();
                if (!com.tp_link.eap.monitor.c.a.b(ap.getModelModelVersion(), ap.getVersion())) continue;
                ae.warn("Firmware version({}) of ap({}) is in incompatible firmware versions, so ignores this firmware.", (Object)ap.getVersion(), (Object)ap.getMac());
                iterator.remove();
            }
            for (Ap ap : list) {
                String string2 = (String)hashMap.get(ap.getModelModelVersion());
                if (string2 != null && com.tp_link.eap.monitor.c.a.a(com.tp_link.eap.monitor.c.a.b(ap.getVersion()), com.tp_link.eap.monitor.c.a.b(string2)) >= 0) continue;
                hashMap.put(ap.getModelModelVersion(), ap.getVersion());
            }
        }
        return hashMap;
    }

    private Map<String, Set<String>> i(String string) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        List<Ap> list = this.getSiteAdoptedAps(string);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                TreeSet<String> treeSet = (TreeSet<String>)hashMap.get(ap.getModelModelVersion());
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    hashMap.put(ap.getModelModelVersion(), treeSet);
                }
                treeSet.add(ap.getVersion());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f(Ap ap) {
        com.tp_link.eap.d.b.b((String)ap.getSite());
        int n2 = (int)this.r.countApActiveClients(ap.getMac(), 0);
        int n3 = (int)this.r.countApActiveClients(ap.getMac(), 1);
        if (n2 != ap.getClientNum2g() || n3 != ap.getClientNum5g()) {
            Object object;
            if (ae.isDebugEnabled()) {
                ae.debug("clientNum of ap {} changed, old clientNum2g is {}, clientNum5g is {}", new Object[]{ap.getMac(), ap.getClientNum2g(), ap.getClientNum5g()});
                ae.debug("new clientNum2g is {}, clientNum5g is {}", (Object)n2, (Object)n3);
            }
            Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
            synchronized (object2) {
                Ap ap2 = this.getApByMac(ap.getMac());
                if (ap2 != null) {
                    ap2.setClientNum2g(n2);
                    ap2.setClientNum5g(n3);
                    ap2.setClientNum(n2 + n3);
                    this.i.save(ap2);
                    StatCurrentAp statCurrentAp = this.j.findByApMac(ap.getMac());
                    if (statCurrentAp != null && statCurrentAp.getSite().equals(ap2.getSite())) {
                        statCurrentAp.setClientNum(ap2.getClientNum());
                        this.j.save(statCurrentAp);
                    } else {
                        ae.error("statCurrentAp is {} for {}", (Object)(statCurrentAp == null ? null : "not in same site"), (Object)ap.getMac());
                    }
                }
            }
        }
    }

    private int b(String string, boolean bl) {
        if (string == null) {
            return 0;
        }
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("isGuest", (Object)bl, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("apMac", (Object)string, QueryFilter.FilterType.eq));
        return (int)this.r.count(arrayList, null);
    }

    static /* synthetic */ Logger a() {
        return ae;
    }

    static /* synthetic */ com.tp_link.eap.monitor.record.service.b a(ApService apService) {
        return apService.y;
    }

    static /* synthetic */ void a(ApService apService, String string, String string2, List list, ExecutorService executorService) {
        apService.a(string, string2, list, executorService);
    }

    static /* synthetic */ boolean a(ApService apService, List list) {
        return apService.e(list);
    }

    static /* synthetic */ ApRepository b(ApService apService) {
        return apService.i;
    }

    static /* synthetic */ OperationResponse a(ApService apService, String string, String string2, String string3, String string4) {
        return apService.a(string, string2, string3, string4);
    }

    static /* synthetic */ void a(ApService apService, String string, String string2, String string3, String string4, boolean bl) {
        apService.a(string, string2, string3, string4, bl);
    }

    static /* synthetic */ com.tp_link.eap.monitor.mesh.service.a c(ApService apService) {
        return apService.D;
    }

    static /* synthetic */ com.tp_link.eap.monitor.mesh.service.c d(ApService apService) {
        return apService.E;
    }

    static /* synthetic */ Object e(ApService apService) {
        return apService.Z;
    }

    static /* synthetic */ ConcurrentHashMap f(ApService apService) {
        return apService.aa;
    }

    static /* synthetic */ com.tp_link.eap.monitor.monitor.service.f g(ApService apService) {
        return apService.m;
    }

    static /* synthetic */ ConcurrentHashMap h(ApService apService) {
        return apService.ab;
    }

    static /* synthetic */ void a(ApService apService, Ap ap) {
        apService.e(ap);
    }
}

